/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public interface ITasksCoreConstants {
    public static final int MAX_SUBTASK_DEPTH = 10;
    public static final String ID_PLUGIN = "org.eclipse.mylyn.tasks.core";
    public static final String OLD_TASK_LIST_FILE = "tasklist.xml";
    public static final String FILENAME_ENCODING = "UTF-8";
    public static final String OLD_PREFIX_TASKLIST = "tasklist";
    public static final String PREFIX_TASKS = "tasks";
    public static final String DEFAULT_BACKUP_FOLDER_NAME = "backup";
    public static final String EXPORT_FILE_NAME = "mylyn-tasks";
    public static final String FILE_EXTENSION = ".xml.zip";
    public static final String OLD_FILENAME_TIMESTAMP_FORMAT = "yyyy-MM-dd";
    public static final String FILENAME_TIMESTAMP_FORMAT = "yyyy-MM-dd-HHmmss";
    public static final String OLD_M_2_TASKLIST_FILENAME = "tasklist.xml.zip";
    public static final String DEFAULT_TASK_LIST_FILE = "tasks.xml.zip";
    public static final String CONTEXTS_DIRECTORY = "contexts";
    public static final ISchedulingRule ACTIVITY_SCHEDULING_RULE = new MutexSchedulingRule();
    public static final ISchedulingRule ACTIVE_CONTEXT_SCHEDULING_RULE = new MutexSchedulingRule();
    public static final ISchedulingRule TASKLIST_SCHEDULING_RULE = new MutexSchedulingRule();
    public static final ISchedulingRule ROOT_SCHEDULING_RULE = new RootSchedulingRule();
    public static final String ATTRIBUTE_OUTGOING_NEW_REPOSITORY_URL = "outgoingNewRepositoryUrl";
    public static final String ATTRIBUTE_OUTGOING_NEW_CONNECTOR_KIND = "outgoingNewConnectorKind";
    public static final String ATTRIBUTE_HIDDEN = "task.common.hidden";
    public static final String ATTRIBUTE_TASK_EXTENDED_TOOLTIP = "task.common.extended.tooltip";
    public static final String ATTRIBUTE_TASK_SUPPRESS_INCOMING = "task.common.suppress.incoming";
    @Deprecated
    public static final String PROPERTY_USE_SECURE_STORAGE = "org.eclipse.mylyn.tasklist.repositories.configuration.securestorage";
    public static final String PROPERTY_BRAND_ID = "org.eclipse.mylyn.brand.id";
    public static final String COMMAND_LINE_NO_ACTIVATE_TASK = "-no-activate-task";
    public static final String PROPERTY_LINK_PROVIDER_TIMEOUT = "org.eclipse.mylyn.linkProviderTimeout";
    public static final String ATTRIBUTE_AUTO_UPDATE = "org.eclipse.mylyn.tasks.core.synchronization.auto";
    public static final Object JOB_FAMILY_SYNCHRONIZATION = new Object();

    public static class MutexSchedulingRule
    extends RootSchedulingRule {
        @Override
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        @Override
        public boolean isConflicting(ISchedulingRule rule) {
            return rule == ROOT_SCHEDULING_RULE || rule == this;
        }
    }

    public static class ObjectSchedulingRule
    extends RootSchedulingRule {
        private final Object object;

        public ObjectSchedulingRule(Object object) {
            Assert.isNotNull((Object)object);
            this.object = object;
        }

        @Override
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        @Override
        public boolean isConflicting(ISchedulingRule rule) {
            if (rule == ROOT_SCHEDULING_RULE) {
                return true;
            }
            if (rule instanceof ObjectSchedulingRule) {
                return this.object.equals(((ObjectSchedulingRule)rule).object);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " [" + this.object + "]";
        }
    }

    public static class RootSchedulingRule
    implements ISchedulingRule {
        protected RootSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof RootSchedulingRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof RootSchedulingRule;
        }
    }
}

