/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.core.util.ContributorBlackList;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryMigrator;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorContributor;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorDescriptor;
import org.eclipse.osgi.util.NLS;

public class RepositoryConnectorExtensionReader {
    public static final String ELMNT_MIGRATOR = "taskListMigrator";
    public static final String ELMNT_REPOSITORY_MIGRATOR = "repositoryMigrator";
    public static final String ELMNT_REPOSITORY_CONNECTOR = "connectorCore";
    public static final String ATTR_ID = "id";
    public static final String ATTR_CLASS = "class";
    private static final String EXTENSION_CONTRIBUTORS = "org.eclipse.mylyn.tasks.core.repositoryConnectorContributor";
    private static final String EXTENSION_REPOSITORIES = "org.eclipse.mylyn.tasks.core.repositories";
    private final ContributorBlackList blackList = new ContributorBlackList();
    private final TaskListExternalizer taskListExternalizer;
    private final TaskRepositoryManager repositoryManager;
    private final List<ConnectorFactory> factories = new ArrayList<ConnectorFactory>();
    private final List<RepositoryConnectorDescriptor> descriptors = new ArrayList<RepositoryConnectorDescriptor>();
    private final MultiStatus result;

    public RepositoryConnectorExtensionReader(TaskListExternalizer taskListExternalizer, TaskRepositoryManager repositoryManager) {
        this.taskListExternalizer = taskListExternalizer;
        this.repositoryManager = repositoryManager;
        this.result = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, "Repository connectors failed to load.", null);
    }

    public void loadConnectors(IExtensionPoint repositoriesExtensionPoint) {
        Map<String, List<ConnectorFactory>> factoryById = this.readFromRepositoriesExtensionPoint(repositoriesExtensionPoint);
        this.checkForConflicts(factoryById);
    }

    public void loadConnectorsFromRepositoriesExtension() {
        this.loadConnectors(Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_REPOSITORIES));
    }

    public void loadConnectorsFromContributors() {
        this.readFromContributorsExtensionPoint();
    }

    public void registerConnectors() {
        Map<String, List<ConnectorFactory>> factoryByConnectorKind = this.createConnectorInstances();
        this.checkForConflicts(factoryByConnectorKind);
        this.registerConnectorInstances();
        if (!this.result.isOK()) {
            StatusHandler.log((IStatus)this.result);
        }
    }

    private void readFromContributorsExtensionPoint() {
        IExtension[] extensions;
        IExtensionPoint repositoriesExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_CONTRIBUTORS);
        IExtension[] iExtensionArray = extensions = repositoriesExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.addDescriptorsFromContributor(element);
                ++n4;
            }
            ++n2;
        }
    }

    private void addDescriptorsFromContributor(final IConfigurationElement element) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                RepositoryConnectorContributor contributor = (RepositoryConnectorContributor)element.createExecutableExtension(RepositoryConnectorExtensionReader.ATTR_CLASS);
                List<RepositoryConnectorDescriptor> descriptors = contributor.getDescriptors();
                if (descriptors == null) {
                    RepositoryConnectorExtensionReader.this.result.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not load connectors contributed by ''{0}''", (Object)element.getContributor().getName())));
                    return;
                }
                for (RepositoryConnectorDescriptor descriptor : descriptors) {
                    if (descriptor == null) continue;
                    RepositoryConnectorExtensionReader.this.factories.add(new ConnectorFactory(descriptor, element.getContributor().getName()));
                }
                RepositoryConnectorExtensionReader.this.descriptors.addAll(descriptors);
            }

            public void handleException(Throwable exception) {
            }
        });
    }

    public Map<String, List<ConnectorFactory>> createConnectorInstances() {
        LinkedHashMap<String, List<ConnectorFactory>> factoryByConnectorKind = new LinkedHashMap<String, List<ConnectorFactory>>();
        for (ConnectorFactory descriptor : this.factories) {
            IStatus status = descriptor.createConnector();
            if (status.isOK() && descriptor.getConnector() != null) {
                this.add(factoryByConnectorKind, descriptor.getConnectorKind(), descriptor);
                continue;
            }
            this.result.add(status);
        }
        return factoryByConnectorKind;
    }

    private void registerConnectorInstances() {
        ArrayList<AbstractTaskListMigrator> taskListmigrators = new ArrayList<AbstractTaskListMigrator>();
        ArrayList<AbstractRepositoryMigrator> repositoryMigrators = new ArrayList<AbstractRepositoryMigrator>();
        for (ConnectorFactory descriptor : this.factories) {
            if (descriptor.getConnector() == null) continue;
            this.repositoryManager.addRepositoryConnector(descriptor.getConnector());
            IStatus status = descriptor.createTaskListMigrator();
            if (status.isOK() && descriptor.getTaskListMigrator() != null) {
                taskListmigrators.add(descriptor.getTaskListMigrator());
            } else if (status.getSeverity() != 8) {
                this.result.add(status);
            }
            status = descriptor.createRepositoryMigrator();
            if (status.isOK() && descriptor.getRepositoryMigrator() != null) {
                repositoryMigrators.add(descriptor.getRepositoryMigrator());
                continue;
            }
            if (status.getSeverity() == 8) continue;
            this.result.add(status);
        }
        this.repositoryManager.initialize(repositoryMigrators);
        this.taskListExternalizer.initialize(taskListmigrators);
    }

    private Map<String, List<ConnectorFactory>> readFromRepositoriesExtensionPoint(IExtensionPoint repositoriesExtensionPoint) {
        IExtension[] repositoryExtensions;
        LinkedHashMap<String, List<ConnectorFactory>> factoryById = new LinkedHashMap<String, List<ConnectorFactory>>();
        IExtension[] iExtensionArray = repositoryExtensions = repositoriesExtensionPoint.getExtensions();
        int n = repositoryExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension repositoryExtension = iExtensionArray[n2];
            IConfigurationElement[] elements = repositoryExtension.getConfigurationElements();
            ExtensionPointBasedConnectorDescriptor descriptor = null;
            IConfigurationElement tasklistMigratorElement = null;
            IConfigurationElement repositoryMigratorElement = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELMNT_REPOSITORY_CONNECTOR)) {
                    descriptor = new ExtensionPointBasedConnectorDescriptor(element);
                } else if (element.getName().equals(ELMNT_MIGRATOR)) {
                    tasklistMigratorElement = element;
                } else if (element.getName().equals(ELMNT_REPOSITORY_MIGRATOR)) {
                    repositoryMigratorElement = element;
                }
                ++n4;
            }
            if (descriptor != null) {
                descriptor.taskListMigratorElement = tasklistMigratorElement;
                descriptor.repositoryMigratorElement = repositoryMigratorElement;
                ConnectorFactory factory = new ConnectorFactory(descriptor, descriptor.getPluginId());
                this.factories.add(factory);
                if (descriptor.getId() != null) {
                    this.add(factoryById, descriptor.getId(), factory);
                }
            }
            ++n2;
        }
        return factoryById;
    }

    private void checkForConflicts(Map<String, List<ConnectorFactory>> descriptorById) {
        for (Map.Entry<String, List<ConnectorFactory>> entry : descriptorById.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            MultiStatus status = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, NLS.bind((String)"Connector ''{0}'' registered by multiple extensions.", (Object)entry.getKey()), null);
            for (ConnectorFactory factory : entry.getValue()) {
                status.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"All extensions contributed by ''{0}'' have been disabled.", (Object)factory.getPluginId()), null));
                this.blackList.disableContributor(factory.getPluginId());
                this.factories.remove(factory);
            }
            this.result.add((IStatus)status);
        }
    }

    private void add(Map<String, List<ConnectorFactory>> descriptorById, String id, ConnectorFactory descriptor) {
        List<ConnectorFactory> list = descriptorById.get(id);
        if (list == null) {
            list = new ArrayList<ConnectorFactory>();
            descriptorById.put(id, list);
        }
        list.add(descriptor);
    }

    public List<RepositoryConnectorDescriptor> getDescriptors() {
        return new ArrayList<RepositoryConnectorDescriptor>(this.descriptors);
    }

    public ContributorBlackList getBlackList() {
        return this.blackList;
    }

    public IStatus getResult() {
        return this.result;
    }

    private static class ConnectorFactory {
        private AbstractRepositoryConnector connector;
        private AbstractTaskListMigrator taskListMigrator;
        private AbstractRepositoryMigrator repositoryMigrator;
        private final RepositoryConnectorDescriptor descriptor;
        private final String pluginId;

        public ConnectorFactory(RepositoryConnectorDescriptor descriptor, String pluginId) {
            Assert.isNotNull((Object)pluginId);
            Assert.isNotNull((Object)pluginId);
            this.descriptor = descriptor;
            this.pluginId = pluginId;
        }

        public String getConnectorKind() {
            return this.getConnector() != null ? this.getConnector().getConnectorKind() : null;
        }

        public AbstractRepositoryConnector getConnector() {
            return this.connector;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public AbstractTaskListMigrator getTaskListMigrator() {
            return this.taskListMigrator;
        }

        public AbstractRepositoryMigrator getRepositoryMigrator() {
            return this.repositoryMigrator;
        }

        public IStatus createConnector() {
            Assert.isTrue((this.connector == null ? 1 : 0) != 0);
            try {
                this.connector = this.descriptor.createRepositoryConnector();
                if (this.connector != null) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not load connector core contributed by ''{0}''", (Object)this.getPluginId()));
            }
            catch (Throwable e) {
                return new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not load connector core contributed by ''{0}''", (Object)this.getPluginId()), e);
            }
        }

        public IStatus createTaskListMigrator() {
            try {
                this.taskListMigrator = this.descriptor.createTaskListMigrator();
                if (this.taskListMigrator != null) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
            catch (Throwable e) {
                return new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not load task list migrator extension contributed by ''{0}''", (Object)this.getPluginId()), e);
            }
        }

        public IStatus createRepositoryMigrator() {
            Assert.isTrue((this.repositoryMigrator == null ? 1 : 0) != 0);
            try {
                this.repositoryMigrator = this.descriptor.createRepositoryMigrator();
                if (this.repositoryMigrator != null) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
            catch (Throwable e) {
                return new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not load repository migrator extension contributed by ''{0}''", (Object)this.getPluginId()), e);
            }
        }
    }

    private static class ExtensionPointBasedConnectorDescriptor
    extends RepositoryConnectorDescriptor {
        IConfigurationElement element;
        IConfigurationElement taskListMigratorElement;
        IConfigurationElement repositoryMigratorElement;

        public ExtensionPointBasedConnectorDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        @Override
        public AbstractRepositoryConnector createRepositoryConnector() {
            try {
                return (AbstractRepositoryConnector)this.element.createExecutableExtension(RepositoryConnectorExtensionReader.ATTR_CLASS);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public AbstractTaskListMigrator createTaskListMigrator() {
            if (this.taskListMigratorElement == null) {
                return null;
            }
            try {
                return (AbstractTaskListMigrator)this.taskListMigratorElement.createExecutableExtension(RepositoryConnectorExtensionReader.ATTR_CLASS);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public AbstractRepositoryMigrator createRepositoryMigrator() {
            if (this.repositoryMigratorElement == null) {
                return null;
            }
            try {
                return (AbstractRepositoryMigrator)this.repositoryMigratorElement.createExecutableExtension(RepositoryConnectorExtensionReader.ATTR_CLASS);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        public String getPluginId() {
            return this.element.getContributor().getName();
        }

        public String getId() {
            return this.element.getAttribute(RepositoryConnectorExtensionReader.ATTR_ID);
        }
    }
}

