/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.html.editor.codegen.LoremIpsumPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoremIpsumGenerator
implements CodeGenerator {
    JTextComponent textComp;

    private LoremIpsumGenerator(Lookup context) {
        this.textComp = (JTextComponent)context.lookup(JTextComponent.class);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_lorem_ipsum");
    }

    private static List<String> completeParagraphList() {
        ArrayList<String> paragraphs = new ArrayList<String>();
        for (int paragraphNumber = 1; paragraphNumber <= 10; ++paragraphNumber) {
            paragraphs.add(NbBundle.getMessage(LoremIpsumGenerator.class, (String)("lorem_ipsum_paragraph_" + paragraphNumber)));
        }
        return paragraphs;
    }

    public void invoke() {
        int caretOffset = this.textComp.getCaretPosition();
        LoremIpsumPanel panel = new LoremIpsumPanel(LoremIpsumGenerator.completeParagraphList());
        String title = NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_generate_lorem_ipsum");
        DialogDescriptor dialogDescriptor = LoremIpsumGenerator.createDialogDescriptor(panel, title);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue()) {
            LoremIpsumGenerator.insertLoremIpsumText((BaseDocument)this.textComp.getDocument(), panel.getParagraphs(), panel.getTag(), caretOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void insertLoremIpsumText(final BaseDocument document, final List<String> paragraphs, final String tag, final int offset) {
        final Reformat reformat = Reformat.get((Document)document);
        reformat.lock();
        try {
            document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        StringBuilder litext = LoremIpsumGenerator.getLoremIpsumText(paragraphs, tag);
                        if (!Utilities.isRowWhite((BaseDocument)document, (int)offset)) {
                            litext.insert(0, '\n');
                        }
                        document.insertString(offset, litext.toString(), null);
                        reformat.reformat(offset, offset + litext.length());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        finally {
            reformat.unlock();
        }
    }

    private static StringBuilder getLoremIpsumText(List<String> paragraphs, String tag) {
        StringBuilder insertText = new StringBuilder();
        String closeTag = tag.replaceFirst("<", "</");
        for (String paragraph : paragraphs) {
            insertText.append(tag).append("\n");
            insertText.append(paragraph).append("\n");
            insertText.append(closeTag).append("\n");
        }
        return insertText;
    }

    private static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[2];
        buttons[0] = new JButton(NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_generate_button"));
        buttons[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LoremIpsumGenerator.class, (String)"A11Y_Generate"));
        buttons[1] = new JButton(NbBundle.getMessage(LoremIpsumGenerator.class, (String)"LBL_cancel_button"));
        return new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            return Collections.singletonList(new LoremIpsumGenerator(context));
        }
    }
}

