/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;

class HtmlRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(ParserResult info, int caretOffset, String[] explanationRetValue) {
        int astCaretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (astCaretOffset == -1) {
            return false;
        }
        HtmlParserResult result = (HtmlParserResult)info;
        Element node = result.findByPhysicalRange(astCaretOffset, true);
        if (node == null) {
            return false;
        }
        switch (node.type()) {
            case OPEN_TAG: {
                OpenTag ot = (OpenTag)node;
                int from = node.from();
                int to = from + 1 + ot.name().length();
                return astCaretOffset >= from && astCaretOffset <= to;
            }
            case CLOSE_TAG: {
                return true;
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult info, int caretOffset) {
        CloseTag close;
        OpenTag open;
        int astCaretOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        if (astCaretOffset == -1) {
            return Collections.emptySet();
        }
        HtmlParserResult result = (HtmlParserResult)info;
        Element node = result.findByPhysicalRange(astCaretOffset, true);
        if (node == null) {
            return Collections.emptySet();
        }
        switch (node.type()) {
            case OPEN_TAG: {
                open = (OpenTag)node;
                close = open.matchingCloseTag();
                break;
            }
            case CLOSE_TAG: {
                close = (CloseTag)node;
                open = close.matchingOpenTag();
                break;
            }
            default: {
                return Collections.emptySet();
            }
        }
        if (open == null || close == null) {
            return Collections.emptySet();
        }
        Snapshot s = info.getSnapshot();
        HashSet<OffsetRange> set = new HashSet<OffsetRange>();
        set.add(new OffsetRange(s.getOriginalOffset(open.from()) + 1, s.getOriginalOffset(open.from() + 1 + open.name().length())));
        set.add(new OffsetRange(s.getOriginalOffset(close.from() + 2), s.getOriginalOffset(close.from() + 2 + close.name().length())));
        return set;
    }
}

