/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api;

import java.util.Collection;
import java.util.List;
import org.netbeans.modules.css.lib.api.Node;

public abstract class NodeVisitor<T> {
    private T result;
    private boolean cancelled = false;

    public NodeVisitor(T result) {
        this.result = result;
    }

    public NodeVisitor() {
        this(null);
    }

    public abstract boolean visit(Node var1);

    public T getResult() {
        return this.result;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void visitAncestors(Node node) {
        Node parent = node.parent();
        if (parent != null) {
            if (this.isCancelled()) {
                return;
            }
            if (this.visit(parent)) {
                return;
            }
            this.visitAncestors(parent);
        }
    }

    public Node visitChildren(Node node) {
        List<Node> children = node.children();
        if (children != null) {
            for (Node child : children) {
                if (this.isCancelled()) {
                    return null;
                }
                if (this.visit(child)) {
                    return child;
                }
                Node breakNode = this.visitChildren(child);
                if (breakNode == null) continue;
                return breakNode;
            }
        }
        return null;
    }

    public static <TE> void visitChildren(Node node, Collection<NodeVisitor<TE>> visitors) {
        List<Node> children = node.children();
        if (children != null) {
            for (Node child : children) {
                for (NodeVisitor<TE> v : visitors) {
                    if (v.isCancelled()) continue;
                    v.visit(child);
                }
                NodeVisitor.visitChildren(child, visitors);
            }
        }
    }
}

