/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.LocalizationSupport;

public class LanguagesGenerateFoldPopupAction
extends NbEditorKit.GenerateFoldPopupAction {
    public static final String EXPAND_PREFIX = "Expand:";
    public static final String COLLAPSE_PREFIX = "Collapse:";

    protected void addAdditionalItems(JTextComponent target, JMenu menu) {
        try {
            String mimeType = (String)target.getDocument().getProperty("mimeType");
            Language l = LanguagesManager.getDefault().getLanguage(mimeType);
            HashSet expands = new HashSet();
            this.addFoldTypes(target, menu, l, expands);
            Iterator<Language> it = l.getImportedLanguages().iterator();
            while (it.hasNext()) {
                this.addFoldTypes(target, menu, it.next(), expands);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void addFoldTypes(JTextComponent target, JMenu menu, Language language, Set expands) {
        List<Feature> features = language.getFeatureList().getFeatures("FOLD");
        for (Feature fold : features) {
            String expand = LocalizationSupport.localize(language, (String)fold.getValue("expand_type_action_name"));
            if (expand == null || expands.contains(expand)) continue;
            expands.add(expand);
            String collapse = LocalizationSupport.localize(language, (String)fold.getValue("collapse_type_action_name"));
            if (collapse == null) continue;
            this.addAction(target, menu, EXPAND_PREFIX + expand);
            this.addAction(target, menu, COLLAPSE_PREFIX + collapse);
            this.setAddSeparatorBeforeNextAction(true);
        }
    }
}

