/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.newproject;

import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;

public final class ContentPanel
extends JPanel {
    static String FINDING_MODULES = "finding-modules";
    private String name = null;
    private JPanel pCentral;
    private JScrollPane spTable;
    private JTable tModules;

    public ContentPanel(String name) {
        this.initComponents();
        this.name = name;
        this.spTable.setVisible(false);
        this.tModules.setVisible(false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FeatureManager.getInstance().create(new Runnable(){

            @Override
            public void run() {
                ContentPanel.this.firePropertyChange(FINDING_MODULES, null, Boolean.TRUE);
            }
        }).schedule(200);
    }

    private void doReplaceComponents(JComponent ... comps) {
        assert (this.pCentral != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        this.pCentral.removeAll();
        this.pCentral.repaint();
        this.addComponents(comps);
    }

    private void doAddComponents(JComponent ... comps) {
        assert (this.pCentral != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        if (comps != null) {
            for (JComponent c : comps) {
                if (c == null) continue;
                this.pCentral.add(c);
            }
        }
        this.pCentral.revalidate();
        this.revalidate();
    }

    public void replaceComponents(final JComponent ... comps) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doReplaceComponents(comps);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContentPanel.this.doReplaceComponents(comps);
                }
            });
        }
    }

    public void addComponents(final JComponent ... comps) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAddComponents(comps);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContentPanel.this.doAddComponents(comps);
                }
            });
        }
    }

    private static String prepareToolTip(String original) {
        String res = "";
        res = "<html>" + original.replaceAll(",", "<br>") + "</html>";
        return res;
    }

    private void initComponents() {
        this.pCentral = new JPanel();
        this.spTable = new JScrollPane();
        this.tModules = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent && vColIndex != 0) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(ContentPanel.prepareToolTip((String)this.getValueAt(rowIndex, vColIndex)));
                }
                return c;
            }
        };
        this.pCentral.setLayout(new BoxLayout(this.pCentral, 1));
        this.tModules.setRowSelectionAllowed(false);
        this.spTable.setViewportView(this.tModules);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pCentral, -1, 448, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.spTable, -1, 436, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pCentral, -1, 25, Short.MAX_VALUE).addGap(25, 25, 25).addComponent(this.spTable, -2, 247, -2).addContainerGap()));
    }
}

