/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.nodes.RestServiceNode;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

class RestServiceChildFactory
extends ChildFactory<RestServiceDescription>
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(RestServiceChildFactory.class.getName());
    private static final RSDescriptionComparator COMPARATOR = new RSDescriptionComparator();
    private Project project;

    RestServiceChildFactory(Project project, RestSupport restSupport) {
        RestServicesModel restModel;
        this.project = project;
        if (restSupport != null && (restModel = restSupport.getRestServicesModel()) != null) {
            restModel.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected boolean createKeys(final List<RestServiceDescription> keys) {
        try {
            RestServicesModel model = this.getModel();
            if (model != null) {
                if (Thread.interrupted()) {
                    return true;
                }
            } else {
                LOG.log(Level.INFO, "RestServicesModel is null");
                return true;
            }
            model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata metadata) throws IOException {
                    RestServiceDescription[] restServiceDescription = metadata.getRoot().getRestServiceDescription();
                    Arrays.sort(restServiceDescription, COMPARATOR);
                    for (RestServiceDescription r : restServiceDescription) {
                        if (r.getFile() == null) continue;
                        keys.add(r);
                    }
                    return null;
                }
            });
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    protected Node createNodeForKey(RestServiceDescription key) {
        return new RestServiceNode(this.project, this.getModel(), key);
    }

    private RestServicesModel getModel() {
        RestSupport support = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
        if (support != null) {
            return support.getRestServicesModel();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("/restservices".equals(evt.getPropertyName())) {
            this.refresh(false);
        }
    }

    private static class RSDescriptionComparator
    implements Comparator<RestServiceDescription> {
        private RSDescriptionComparator() {
        }

        @Override
        public int compare(RestServiceDescription desc1, RestServiceDescription desc2) {
            String key1 = RestServiceNode.getKey(desc1);
            String key2 = RestServiceNode.getKey(desc2);
            return key1.compareTo(key2);
        }
    }
}

