/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitPanel;
import org.netbeans.modules.subversion.ui.commit.CommitTableModel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommitTable
implements AncestorListener,
TableModelListener,
MouseListener {
    public static String[] COMMIT_COLUMNS = new String[]{"commit", "name", "status", "action", "path"};
    public static String[] IMPORT_COLUMNS = new String[]{"commit", "name", "action", "path"};
    private CommitTableModel tableModel;
    private JTable table;
    private JComponent component;
    private TableSorter sorter;
    private String[] columns;
    private Map<String, Integer> sortByColumns;
    private CommitPanel commitPanel;
    private Set<File> modifiedFiles = Collections.emptySet();

    public CommitTable(JLabel label, String[] columns, Map<String, Integer> sortByColumns) {
        this.init(label, columns, null);
        this.sortByColumns = sortByColumns;
        this.setSortingStatus();
    }

    public CommitTable(JLabel label, String[] columns, TableSorter sorter) {
        this.init(label, columns, sorter);
    }

    private void init(JLabel label, String[] columns, TableSorter sorter) {
        this.tableModel = new CommitTableModel(columns);
        this.tableModel.addTableModelListener(this);
        if (sorter == null) {
            sorter = new TableSorter((TableModel)this.tableModel);
        }
        this.sorter = sorter;
        this.table = new SortedTable(this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new CommitStringsCellRenderer());
        this.table.setDefaultRenderer(Boolean.class, new CheckboxCellRenderer());
        this.table.setDefaultEditor(Boolean.class, new CheckboxCellEditor());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 31);
        label.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitTable.class, (String)"ACSD_CommitTable"));
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommitTable.this.showPopup(Utils.getPositionForPopup((JTable)CommitTable.this.table));
            }
        });
        this.table.addMouseListener(this);
        this.setColumns(columns);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        block17: {
            TableColumnModel columnModel;
            int width;
            block18: {
                block16: {
                    width = this.table.getWidth();
                    columnModel = this.table.getColumnModel();
                    if (this.columns == null || columnModel == null) {
                        return;
                    }
                    if (columnModel.getColumnCount() != this.columns.length) {
                        return;
                    }
                    if (this.columns.length != 4) break block16;
                    for (int i = 0; i < this.columns.length; ++i) {
                        String col = this.columns[i];
                        this.sorter.setColumnComparator(i, null);
                        if (col.equals("commit")) {
                            columnModel.getColumn(i).setMinWidth(new JCheckBox().getMinimumSize().width);
                            columnModel.getColumn(i).setPreferredWidth(new JCheckBox().getPreferredSize().width);
                            continue;
                        }
                        if (col.equals("name")) {
                            this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                            columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
                            continue;
                        }
                        if (col.equals("action")) {
                            columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                            continue;
                        }
                        columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                    }
                    break block17;
                }
                if (this.columns.length != 5) break block18;
                for (int i = 0; i < this.columns.length; ++i) {
                    String col = this.columns[i];
                    this.sorter.setColumnComparator(i, null);
                    if (col.equals("commit")) {
                        columnModel.getColumn(i).setMinWidth(new JCheckBox().getMinimumSize().width);
                        columnModel.getColumn(i).setPreferredWidth(new JCheckBox().getPreferredSize().width);
                        continue;
                    }
                    if (col.equals("name")) {
                        this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
                        continue;
                    }
                    if (col.equals("status")) {
                        this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    if (col.equals("action")) {
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                }
                break block17;
            }
            if (this.columns.length != 6) break block17;
            for (int i = 0; i < this.columns.length; ++i) {
                String col = this.columns[i];
                this.sorter.setColumnComparator(i, null);
                if (col.equals("commit")) {
                    columnModel.getColumn(i).setMinWidth(new JCheckBox().getMinimumSize().width);
                    columnModel.getColumn(i).setPreferredWidth(new JCheckBox().getPreferredSize().width);
                    continue;
                }
                if (col.equals("name")) {
                    this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                    columnModel.getColumn(i).setPreferredWidth(width * 25 / 100);
                    continue;
                }
                if (col.equals("status")) {
                    this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                    this.sorter.setSortingStatus(i, 1);
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                if (col.equals("action")) {
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
            }
        }
    }

    private void setSortingStatus() {
        block0: for (Map.Entry<String, Integer> e : this.sortByColumns.entrySet()) {
            String sortByColumn = e.getKey();
            for (int j = 0; j < this.columns.length; ++j) {
                String column = this.columns[j];
                if (!column.equals(sortByColumn)) continue;
                this.sorter.setSortingStatus(j, e.getValue().intValue());
                continue block0;
            }
        }
    }

    public LinkedHashMap<String, Integer> getSortingState() {
        LinkedHashMap sorterState = this.sorter.getSortingState();
        LinkedHashMap<String, Integer> sortingStatus = new LinkedHashMap<String, Integer>(sorterState.size());
        for (Map.Entry e : sorterState.entrySet()) {
            sortingStatus.put(this.columns[(Integer)e.getKey()], (Integer)e.getValue());
        }
        return sortingStatus;
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(this.columns, cols)) {
            return;
        }
        this.columns = cols;
        this.tableModel.setColumns(cols);
        this.setDefaultColumnSizes();
    }

    public void setNodes(SvnFileNode[] nodes) {
        this.tableModel.setNodes(nodes);
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        return this.tableModel.getCommitFiles();
    }

    public JComponent getComponent() {
        return this.component;
    }

    void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.table.repaint();
    }

    public void setRootFile(String repositoryPath, String rootLocalPath) {
        this.tableModel.setRootFile(repositoryPath, rootLocalPath);
    }

    private void showPopup(final MouseEvent e) {
        int i;
        int row = this.table.rowAtPoint(e.getPoint());
        int col = this.table.columnAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        if (col != -1) {
            boolean makeColSelected = true;
            int[] selectedcols = this.table.getSelectedColumns();
            for (i = 0; i < selectedcols.length; ++i) {
                if (col != selectedcols[i]) continue;
                makeColSelected = false;
                break;
            }
            if (makeColSelected) {
                this.table.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CommitTable.this.table.isShowing()) {
                    JPopupMenu menu = CommitTable.this.getPopup();
                    menu.show(CommitTable.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        menu.show(this.table, p.x, p.y);
    }

    private JPopupMenu getPopup() {
        JMenuItem item;
        JPopupMenu menu = new JPopupMenu();
        boolean containsExcluded = false;
        boolean containsIncluded = false;
        boolean anyDirectory = false;
        boolean addAllowed = true;
        for (int rowIndex : this.table.getSelectedRows()) {
            int row = this.sorter.modelIndex(rowIndex);
            SvnFileNode node = this.tableModel.getNode(row);
            FileInformation fileInfo = node.getInformation();
            if (CommitOptions.EXCLUDE.equals(this.tableModel.getOptions(row))) {
                containsExcluded = true;
            } else {
                containsIncluded = true;
            }
            if (fileInfo.isDirectory()) {
                anyDirectory = true;
            }
            if (node.isFile() && (node.getInformation().getStatus() & 4) != 0) continue;
            addAllowed = false;
        }
        if (containsExcluded) {
            item = menu.add(new PopupAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_IncludeAction")){

                @Override
                public void performAction(ActionEvent e) {
                    int[] rows = this.getRows();
                    CommitTable.this.tableModel.setIncluded(rows, true, false);
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add(new PopupAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_IncludeRecursivelyAction")){

                @Override
                public void performAction(ActionEvent e) {
                    int[] rows = this.getRows();
                    CommitTable.this.tableModel.setIncluded(rows, true, true);
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item.setEnabled(anyDirectory);
        }
        if (containsIncluded) {
            item = menu.add(new PopupAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_ExcludeAction")){

                @Override
                public void performAction(ActionEvent e) {
                    int[] rows = this.getRows();
                    CommitTable.this.tableModel.setIncluded(rows, false, false);
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add(new PopupAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_ExcludeRecursivelyAction")){

                @Override
                public void performAction(ActionEvent e) {
                    int[] rows = this.getRows();
                    CommitTable.this.tableModel.setIncluded(rows, false, true);
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item.setEnabled(anyDirectory);
        }
        item = menu.add(new PopupAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_AddTextAction")){

            @Override
            public void performAction(ActionEvent e) {
                int[] rows = this.getRows();
                CommitTable.this.tableModel.setAdded(rows, CommitOptions.ADD_TEXT);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item.setEnabled(addAllowed);
        item = menu.add(new PopupAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_AddBinaryAction")){

            @Override
            public void performAction(ActionEvent e) {
                int[] rows = this.getRows();
                CommitTable.this.tableModel.setAdded(rows, CommitOptions.ADD_BINARY);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item.setEnabled(addAllowed);
        item = menu.add(new AbstractAction(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_DiffAction")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommitTable.this.openDiff();
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item.setEnabled(this.commitPanel != null);
        return menu;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.commitPanel != null) {
            this.openDiff();
        }
    }

    private void openDiff() {
        int[] rows = this.table.getSelectedRows();
        SvnFileNode[] nodes = new SvnFileNode[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            nodes[i] = this.tableModel.getNode(this.sorter.modelIndex(rows[i]));
        }
        this.commitPanel.openDiff(nodes);
    }

    void setCommitPanel(CommitPanel panel) {
        this.commitPanel = panel;
    }

    void setModifiedFiles(Set<File> modifiedFiles) {
        this.modifiedFiles = modifiedFiles;
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return CommitTable.this.tableModel.getNode(row1).getName().compareToIgnoreCase(CommitTable.this.tableModel.getNode(row2).getName());
        }
    }

    private class StatusComparator
    extends SvnUtils.ByImportanceComparator {
        private StatusComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return super.compare(CommitTable.this.tableModel.getNode(row1).getInformation(), CommitTable.this.tableModel.getNode(row2).getInformation());
        }
    }

    private class CheckboxCellEditor
    extends DefaultCellEditor {
        public CheckboxCellEditor() {
            super(new JCheckBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JCheckBox checkbox = (JCheckBox)this.editorComponent;
            checkbox.setSelected(value == null ? false : (Boolean)value);
            checkbox.setHorizontalAlignment(2);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class CheckboxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();

        public CheckboxCellRenderer() {
            this.setToolTipText(NbBundle.getMessage(CommitTable.class, (String)"CTL_CommitTable_Column_Description"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected(value == null ? false : (Boolean)value);
            Color c = this.renderer.getTableCellRendererComponent(table, "value", isSelected, hasFocus, row, column).getBackground();
            this.setBackground(new Color(c.getRGB()));
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    private class CommitStringsCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private CommitStringsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col = table.convertColumnIndexToModel(column);
            if ("name".equals(CommitTable.this.columns[col])) {
                TableSorter sorter = (TableSorter)table.getModel();
                CommitTableModel model = (CommitTableModel)sorter.getTableModel();
                SvnFileNode node = model.getNode(sorter.modelIndex(row));
                CommitOptions options = model.getOptions(sorter.modelIndex(row));
                if (!isSelected) {
                    value = Subversion.getInstance().getAnnotator().annotateNameHtml(node.getFile().getName(), node.getInformation(), null);
                }
                if (options == CommitOptions.EXCLUDE) {
                    value = "<s>" + value + "</s>";
                }
                if (CommitTable.this.modifiedFiles.contains(node.getFile())) {
                    value = "<strong>" + value + "</strong>";
                }
                value = "<html>" + value + "</html>";
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if ("path".equals(CommitTable.this.columns[col])) {
                return this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private abstract class PopupAction
    extends AbstractAction {
        private int[] rows;

        public PopupAction(String name) {
            super(name);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            int i;
            this.rows = CommitTable.this.table.getSelectedRows();
            int rowCount = CommitTable.this.table.getRowCount();
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = CommitTable.this.sorter.modelIndex(this.rows[i]);
            }
            this.performAction(e);
            if (rowCount == CommitTable.this.table.getRowCount()) {
                for (i = 0; i < this.rows.length; ++i) {
                    CommitTable.this.table.getSelectionModel().addSelectionInterval(CommitTable.this.sorter.viewIndex(this.rows[i]), CommitTable.this.sorter.viewIndex(this.rows[i]));
                }
            }
        }

        protected int[] getRows() {
            return this.rows;
        }

        protected abstract void performAction(ActionEvent var1);
    }
}

