/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.history.DiffResultsView;
import org.netbeans.modules.subversion.ui.history.DiffResultsViewForLine;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SearchHistoryAction
extends ContextAction {
    static final int DIRECTORY_ENABLED_STATUS = -8;
    static final int FILE_ENABLED_STATUS = -8;
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/resources/icons/search_history.png";

    public SearchHistoryAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_SearchHistory";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -8;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        SearchHistoryAction.openHistory(this.getContext(nodes).getFiles(), NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)this.getContextDisplayName(nodes)));
    }

    public static void openHistory(File[] files) {
        SearchHistoryAction.openHistory(files, NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)files[0].getName()));
    }

    private static void openHistory(final File[] files, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(files);
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                if (files.length == 1 && files[0].isFile() || files.length > 1 && Utils.shareCommonDataObject((File[])files)) {
                    tc.search(false);
                }
            }
        });
    }

    public static void openSearch(File file, final int lineNumber) {
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(file, new SearchHistoryTopComponent.DiffResultsViewFactory(){

            @Override
            DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
                return new DiffResultsViewForLine(panel, results, lineNumber);
            }
        });
        String tcTitle = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)file.getName());
        tc.setDisplayName(tcTitle);
        tc.open();
        tc.requestActive();
        tc.search(true);
        tc.activateDiffView(true);
    }

    private static Context getDefaultContext() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        return SvnUtils.getProjectsContext(projects);
    }

    public static void openSearch(SVNUrl repositoryUrl, File localRoot, long revision) {
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repositoryUrl, localRoot, revision);
        String tcTitle = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)repositoryUrl);
        tc.setDisplayName(tcTitle);
        tc.open();
        tc.requestActive();
        tc.search(false);
    }
}

