/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JToolTip;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.models.Bundle;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractModelNode;
import org.netbeans.modules.php.dbgp.models.nodes.VariableNode;
import org.netbeans.modules.php.dbgp.packets.ContextNamesResponse;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.modules.php.dbgp.packets.PropertyGetCommand;
import org.netbeans.modules.php.dbgp.packets.PropertySetCommand;
import org.netbeans.modules.php.dbgp.packets.PropertyValueCommand;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class VariablesModel
extends ViewModelSupport
implements TreeModel,
TableModel,
NodeModel {
    private static final Logger LOGGER = Logger.getLogger(VariablesModel.class.getName());
    private static final boolean SHOW_FULL_VALUES = Boolean.getBoolean("nb.php.debugger.full.values");
    private static final String FULL_VALUE_LENGTH = "nb.php.debugger.full.value.length";
    private static final int MAX_VALUE_LENGTH;
    private static final int DEFAULT_MAX_VALUE_LENGTH = 2000;
    private static final String EVALUATING = "TXT_Evaluating";
    static final String GET_SHORT_DESCRIPTION = "getShortDescription";
    static final String NULL = "null";
    private final ContextProvider myContextProvider;
    private DebugSession debugSession;
    private List<ModelNode> myNodes;
    private ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock myReadlock = this.myLock.readLock();
    private ReentrantReadWriteLock.WriteLock myWritelock = this.myLock.writeLock();

    public VariablesModel(ContextProvider contextProvider) {
        this.myContextProvider = contextProvider;
        this.myNodes = new LinkedList<ModelNode>();
    }

    @Override
    public void clearModel() {
        this.myWritelock.lock();
        try {
            this.myNodes.clear();
        }
        finally {
            this.myWritelock.unlock();
        }
        this.fireTreeChanged();
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        this.myReadlock.lock();
        try {
            ModelNode usedParent = null;
            if (parent == "Root") {
                List<ModelNode> list = this.getTopLevelElements();
                if (from >= list.size()) {
                    Object[] objectArray = new Object[]{};
                    return objectArray;
                }
                int end = Math.min(list.size(), to);
                List<ModelNode> contexts = list.subList(from, end);
                Object[] objectArray = contexts.toArray(new Object[contexts.size()]);
                return objectArray;
            }
            if (parent instanceof ModelNode) {
                usedParent = (ModelNode)parent;
            }
            if (usedParent != null) {
                int size = ((ModelNode)parent).getChildrenSize();
                if (from >= size) {
                    Object[] end = new Object[]{};
                    return end;
                }
                int end = Math.min(size, to);
                Object[] objectArray = ((ModelNode)parent).getChildren(from, end);
                return objectArray;
            }
        }
        finally {
            this.myReadlock.unlock();
        }
        throw new UnknownTypeException((Object)(parent + " " + parent.getClass().getName()));
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == null) {
            return true;
        }
        if (node == "Root") {
            return this.myNodes.isEmpty();
        }
        if (node instanceof ModelNode) {
            ModelNode modelNode = (ModelNode)node;
            DebugSession session = this.getSession();
            if (session != null) {
                this.childrenRequest(modelNode, session);
                this.fillChildrenList(modelNode, session);
            }
            return modelNode.isLeaf();
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        this.myReadlock.lock();
        try {
            if (node == "Root") {
                int n = this.getTopLevelElements().size();
                return n;
            }
            if (node instanceof ModelNode) {
                int n = ((ModelNode)node).getChildrenSize();
                return n;
            }
            throw new UnknownTypeException(node);
        }
        finally {
            this.myReadlock.unlock();
        }
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof JToolTip) {
            return this.getTooltip((JToolTip)node, columnID);
        }
        String result = "";
        switch (columnID) {
            case "LocalsType": {
                if (node instanceof ModelNode) {
                    String type = ((ModelNode)node).getType();
                    assert (type != null);
                    result = type;
                    break;
                }
                result = node != null ? node.getClass().getName() : "";
                break;
            }
            case "LocalsValue": {
                if (node instanceof ModelNode) {
                    ModelNode modelNode = (ModelNode)node;
                    try {
                        result = this.shortenValue(modelNode.getValue());
                        break;
                    }
                    catch (UnsufficientValueException e) {
                        this.sendValueCommand(modelNode);
                        return NbBundle.getMessage(VariablesModel.class, (String)EVALUATING);
                    }
                }
                if (node != null) break;
                result = "";
                break;
            }
        }
        return result;
    }

    public boolean isReadOnly(Object node, String string) throws UnknownTypeException {
        return false;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        assert (value instanceof String);
        if ("LocalsValue".equals(columnID)) {
            if (!(node instanceof VariableNode)) {
                throw new UnknownTypeException(node);
            }
            ModelNode modelNode = (ModelNode)node;
            if (modelNode.isReadOnly()) {
                throw new UnknownTypeException(node);
            }
            DebugSession session = this.getSession();
            if (session == null) {
                return;
            }
            PropertySetCommand command = new PropertySetCommand(session.getTransactionId());
            command.setData((String)value);
            assert (node instanceof AbstractVariableNode);
            ((AbstractVariableNode)node).setupCommand(command);
            session.sendCommandLater(command);
        }
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        String retval = null;
        if (node == "Root") {
            retval = "Root";
        } else if (node instanceof ModelNode) {
            retval = ((ModelNode)node).getName();
        } else if (node != null) {
            throw new UnknownTypeException(node);
        }
        if (retval == null && node != null) {
            Logger.getLogger(VariablesModel.class.getName()).log(Level.WARNING, "display name isn''t expected to be null: {0}", node.getClass().getName());
        }
        return retval != null ? retval : NULL;
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node == null || node == "Root") {
            return "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getIconBase();
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == null || node == "Root") {
            return null;
        }
        if (node instanceof ModelNode) {
            return ((ModelNode)node).getShortDescription();
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContext(ContextNode node) {
        this.myWritelock.lock();
        try {
            if (this.myNodes.isEmpty()) {
                this.myNodes.add(node);
            } else {
                boolean found = false;
                for (ModelNode child : this.myNodes) {
                    if (!(child instanceof ContextNode) || !node.equalsTo((ContextNode)child)) continue;
                    this.updateContext((ContextNode)child, node);
                    found = true;
                }
                if (!found) {
                    this.myNodes.add(node);
                }
            }
            this.fireTreeChanged();
        }
        finally {
            this.myWritelock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(Property property) {
        this.myWritelock.lock();
        try {
            for (ModelNode node : this.myNodes) {
                if (!this.updateVariable(node, property)) continue;
                return;
            }
        }
        finally {
            this.myWritelock.unlock();
        }
    }

    private boolean updateVariable(ModelNode node, Property property) {
        if (node instanceof AbstractVariableNode) {
            AbstractVariableNode var = (AbstractVariableNode)node;
            String name = var.getFullName();
            String propertyFullName = property.getFullName();
            String propertyName = property.getName();
            if (propertyFullName != null && propertyFullName.equals(name) || propertyName.equals(name)) {
                ArrayList<ModelEvent> events = new ArrayList<ModelEvent>();
                var.collectUpdates(this, AbstractModelNode.createVariable(property, var.getParent()), events);
                this.fireTableUpdate(events);
                return true;
            }
        }
        for (ModelNode child : node.getChildren(0, node.getChildrenSize())) {
            if (!this.updateVariable(child, property)) continue;
            return true;
        }
        return false;
    }

    private List<ModelNode> getTopLevelElements() {
        LinkedList<ModelNode> result = new LinkedList<ModelNode>();
        for (ModelNode node : this.myNodes) {
            if (node instanceof ContextNode && !((ContextNode)node).isGlobal()) {
                result.addAll(Arrays.asList(node.getChildren(0, node.getChildrenSize())));
                continue;
            }
            result.add(0, node);
        }
        return result;
    }

    private String getTooltip(JToolTip tooltip, String columnId) throws UnknownTypeException {
        Object row = tooltip.getClientProperty(GET_SHORT_DESCRIPTION);
        if (row instanceof ModelNode) {
            return this.getValueAt(row, columnId).toString();
        }
        throw new UnknownTypeException((Object)tooltip);
    }

    private void sendValueCommand(ModelNode modelNode) {
        if (modelNode instanceof AbstractVariableNode) {
            AbstractVariableNode node = (AbstractVariableNode)modelNode;
            DebugSession session = this.getSession();
            PropertyValueCommand command = new PropertyValueCommand(session.getTransactionId());
            node.setupCommand(command);
            session.sendCommandLater(command);
        }
    }

    private void updateContext(ContextNode old, ContextNode node) {
        LinkedList<ModelEvent> events = new LinkedList<ModelEvent>();
        old.collectUpdates(this, node, events);
        this.fireTableUpdate(events);
    }

    private void fireTreeChanged() {
        this.refresh();
    }

    private void fireTableUpdate(Collection<ModelEvent> events) {
        this.fireChangeEvents(events);
    }

    private synchronized DebugSession getSession() {
        SessionId id;
        ContextProvider provider;
        if (this.debugSession == null && (provider = this.getContextProvider()) != null && (id = (SessionId)provider.lookupFirst(null, SessionId.class)) != null) {
            this.debugSession = SessionManager.getInstance().getSession(id);
        }
        return this.debugSession;
    }

    private ContextProvider getContextProvider() {
        return this.myContextProvider;
    }

    private void childrenRequest(ModelNode modelNode, DebugSession session) {
        int size = modelNode.getChildrenSize();
        if (!modelNode.isLeaf() && size == 0) {
            assert (modelNode instanceof AbstractVariableNode);
            PropertyGetCommand getCommand = new PropertyGetCommand(session.getTransactionId());
            ((AbstractVariableNode)modelNode).setupCommand(getCommand);
            session.sendCommandLater(getCommand);
        }
    }

    private void fillChildrenList(ModelNode modelNode, DebugSession session) {
        if (!(modelNode instanceof AbstractVariableNode)) {
            return;
        }
        AbstractVariableNode var = (AbstractVariableNode)modelNode;
        if (session != null && !var.isChildrenFilled()) {
            PropertyGetCommand command = new PropertyGetCommand(session.getTransactionId());
            var.setupFillChildrenCommand(command);
            session.sendCommandLater(command);
        }
    }

    private String shortenValue(String value) {
        if (SHOW_FULL_VALUES) {
            return value;
        }
        int length = value.length();
        if (length <= MAX_VALUE_LENGTH) {
            return value;
        }
        LOGGER.log(Level.INFO, "Shortening value from {0} to {1}", new Object[]{length, MAX_VALUE_LENGTH});
        return Bundle.VariablesModel_value_shortened(value.substring(0, MAX_VALUE_LENGTH));
    }

    static {
        if (SHOW_FULL_VALUES) {
            LOGGER.log(Level.INFO, "Max value length unlimited");
            MAX_VALUE_LENGTH = -1;
        } else {
            int maxValueLength;
            try {
                maxValueLength = Integer.parseInt(System.getProperty(FULL_VALUE_LENGTH, String.valueOf(2000)));
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.INFO, "Invalid max value length given", ex);
                maxValueLength = 2000;
            }
            if (maxValueLength <= 10) {
                LOGGER.log(Level.INFO, "Invalid max value length given, must be >= 10 (was {0})", maxValueLength);
                maxValueLength = 2000;
            }
            LOGGER.log(Level.INFO, "Max value length set to {0}", maxValueLength);
            MAX_VALUE_LENGTH = maxValueLength;
        }
    }

    public static abstract class AbstractVariableNode
    extends org.netbeans.modules.php.dbgp.models.nodes.AbstractVariableNode {
        protected AbstractVariableNode(Property property, AbstractModelNode parent) {
            super(property, parent);
        }

        @Override
        protected void collectUpdates(VariablesModel variablesModel, VariableNode node, Collection<ModelEvent> events) {
            AbstractVariableNode newNode = (AbstractVariableNode)node;
            boolean hasChanged = false;
            this.setProperty(newNode.getProperty());
            if (this.updatePage(newNode)) {
                if (newNode.getChildrenSize() > 0) {
                    events.add((ModelEvent)new ModelEvent.NodeChanged((Object)variablesModel, (Object)this));
                }
                return;
            }
            if (!Property.equals(this.getProperty(), newNode.getProperty())) {
                hasChanged = true;
            }
            if ((this.getVariables() == null || this.getVariables().isEmpty()) && newNode.getVariables() != null) {
                this.initVariables(newNode.getProperty().getChildren());
                hasChanged = true;
            } else if (this.getVariables() != null) {
                hasChanged = this.updateExistedChildren(variablesModel, newNode, events) || hasChanged;
                boolean bl = hasChanged = this.addAbsentChildren(newNode) || hasChanged;
            }
            if (hasChanged) {
                events.add((ModelEvent)new ModelEvent.NodeChanged((Object)variablesModel, (Object)this));
            }
        }
    }

    public static class ContextNode
    extends org.netbeans.modules.php.dbgp.models.nodes.ContextNode {
        public ContextNode(ContextNamesResponse.Context ctx, List<Property> properties) {
            super(ctx, properties);
        }

        void collectUpdates(VariablesModel variablesModel, ContextNode node, Collection<ModelEvent> events) {
            boolean hasChanged = false;
            if ((this.getVariables() == null || this.getVariables().isEmpty()) && node.getVariables() != null) {
                this.setVars(node.getVariables());
                hasChanged = true;
            } else if (this.getVariables() != null) {
                hasChanged = this.updateExistedChildren(variablesModel, node, events);
                boolean bl = hasChanged = this.addAbsentChildren(node) || hasChanged;
            }
            if (hasChanged) {
                events.add((ModelEvent)new ModelEvent.NodeChanged((Object)variablesModel, (Object)this));
            }
        }
    }
}

