/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tomcat.util.StringManager;

public class DateTool {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    public static final Locale LOCALE_US = Locale.US;
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyy";
    public static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    public static final SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", LOCALE_US);
    public static final SimpleDateFormat oldCookieFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", LOCALE_US);
    public static final SimpleDateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", LOCALE_US);
    public static final SimpleDateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", LOCALE_US);
    private static String rfc1123DS;
    private static long rfc1123Sec;

    public static String format1123(Date d) {
        long dt = d.getTime() % 1000L;
        if (rfc1123DS != null && dt == rfc1123Sec) {
            return rfc1123DS;
        }
        rfc1123DS = rfc1123Format.format(d);
        rfc1123Sec = dt;
        return rfc1123DS;
    }

    static {
        rfc1123Format.setTimeZone(GMT_ZONE);
        oldCookieFormat.setTimeZone(GMT_ZONE);
        rfc1036Format.setTimeZone(GMT_ZONE);
        asctimeFormat.setTimeZone(GMT_ZONE);
    }
}

