/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lsp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.lsp.Diagnostic;
import org.openide.filesystems.FileObject;

public interface ErrorProvider {
    public List<? extends Diagnostic> computeErrors(Context var1);

    public static enum Kind {
        ERRORS,
        HINTS;

    }

    public static final class Context {
        private final FileObject file;
        private final int offset;
        private final Kind errorKind;
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final List<Runnable> cancelCallbacks = new ArrayList<Runnable>();

        public Context(FileObject file, Kind errorKind) {
            this(file, -1, errorKind);
        }

        public Context(FileObject file, int offset, Kind errorKind) {
            this.file = file;
            this.offset = offset;
            this.errorKind = errorKind;
        }

        public FileObject file() {
            return this.file;
        }

        public int getOffset() {
            return this.offset;
        }

        public Kind errorKind() {
            return this.errorKind;
        }

        public boolean isCancelled() {
            return this.cancel.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            ArrayList<Runnable> callbacks;
            this.cancel.set(true);
            Context context = this;
            synchronized (context) {
                callbacks = new ArrayList<Runnable>(this.cancelCallbacks);
            }
            for (Runnable r : callbacks) {
                r.run();
            }
        }

        public synchronized void registerCancelCallback(Runnable r) {
            this.cancelCallbacks.add(r);
        }
    }
}

