/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum ArchiveType implements ApiFeature
{
    BIN("bin", "bin", "bin"),
    CAB("cab", "cab", ".cab"),
    DEB("deb", "deb", ".deb"),
    DMG("dmg", "dmg", ".dmg"),
    MSI("msi", "msi", ".msi"),
    PKG("pkg", "pkg", ".pkg"),
    RPM("rpm", "rpm", ".rpm"),
    SRC_TAR("src.tar.gz", "src_tar", ".src.tar.gz", ".source.tar.gz", "source.tar.gz"),
    TAR("tar", "tar", ".tar"),
    TAR_GZ("tar.gz", "tar.gz", ".tar.gz"),
    TAR_Z("tar.Z", "tar.z", ".tar.Z"),
    ZIP("zip", "zip", ".zip"),
    EXE("exe", "exe", ".exe"),
    NONE("-", "", "-"),
    NOT_FOUND("", "", "");

    private final String uiString;
    private final String apiString;
    private final List<String> fileEndings;

    private ArchiveType(String uiString, String apiString, String ... fileEndings) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.fileEndings = Arrays.asList(fileEndings);
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public ArchiveType getDefault() {
        return NONE;
    }

    @Override
    public ArchiveType getNotFound() {
        return NOT_FOUND;
    }

    public ArchiveType[] getAll() {
        return ArchiveType.values();
    }

    public static ArchiveType fromText(String text) {
        switch (text) {
            case "bin": 
            case ".bin": 
            case "BIN": {
                return BIN;
            }
            case "cab": 
            case ".cab": 
            case "CAB": {
                return CAB;
            }
            case "deb": 
            case ".deb": 
            case "DEB": {
                return DEB;
            }
            case "dmg": 
            case ".dmg": 
            case "DMG": {
                return DMG;
            }
            case "msi": 
            case ".msi": 
            case "MSI": {
                return MSI;
            }
            case "pkg": 
            case ".pkg": 
            case "PKG": {
                return PKG;
            }
            case "rpm": 
            case ".rpm": 
            case "RPM": {
                return RPM;
            }
            case "src.tar.gz": 
            case ".src.tar.gz": 
            case "source.tar.gz": 
            case "SRC.TAR.GZ": 
            case "src_tar": 
            case "SRC_TAR": {
                return SRC_TAR;
            }
            case "tar.Z": 
            case ".tar.Z": 
            case "TAR.Z": {
                return TAR_Z;
            }
            case "tar.gz": 
            case ".tar.gz": 
            case "TAR.GZ": {
                return TAR_GZ;
            }
            case "tar": 
            case ".tar": 
            case "TAR": {
                return TAR;
            }
            case "zip": 
            case ".zip": 
            case "ZIP": {
                return ZIP;
            }
        }
        return NOT_FOUND;
    }

    public List<String> getFileEndings() {
        return this.fileEndings;
    }

    public static ArchiveType getFromFileName(String fileName) {
        for (ArchiveType ext : ArchiveType.values()) {
            for (String ending : ext.getFileEndings()) {
                if (!fileName.toLowerCase().endsWith(ending)) continue;
                return ext;
            }
        }
        return NONE;
    }

    public static List<ArchiveType> getAsList() {
        return Arrays.asList(ArchiveType.values());
    }
}

