/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MethodPicker;
import org.netbeans.modules.form.PropertyPicker;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class ParametersPicker
extends JPanel {
    static final long serialVersionUID = 1116033799965380000L;
    private boolean previousValue = false;
    private JRadioButton beanButton;
    private JComboBox beanCombo;
    private JEditorPane codeArea;
    private JRadioButton codeButton;
    private JScrollPane codeScrollPane;
    private JRadioButton methodButton;
    private JButton methodDetailsButton;
    private JTextField methodLabel;
    private JLabel paramLabel;
    private JRadioButton propertyButton;
    private JButton propertyDetailsButton;
    private JTextField propertyLabel;
    private JRadioButton valueButton;
    private JTextField valueField;
    private FormModel formModel;
    private Class<?> requiredType;
    private PropertyPicker propertyPicker;
    private List<ChangeListener> listeners;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;
    private MethodDescriptor selectedMethod;
    private List<RADComponent> beansList;

    public ParametersPicker(FormModel formModel, Class requiredType) {
        this.formModel = formModel;
        this.requiredType = requiredType;
        this.initComponents();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.valueButton);
        bg.add(this.beanButton);
        bg.add(this.propertyButton);
        bg.add(this.methodButton);
        bg.add(this.codeButton);
        if (!requiredType.isPrimitive() && !requiredType.equals(String.class)) {
            this.valueButton.setEnabled(false);
            this.propertyButton.setSelected(true);
        }
        this.paramLabel.setLabelFor(this);
        this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        Mnemonics.setLocalizedText((AbstractButton)this.valueButton, (String)FormUtils.getBundleString("CTL_CW_Value"));
        Mnemonics.setLocalizedText((AbstractButton)this.beanButton, (String)FormUtils.getBundleString("CTL_CW_Bean"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertyButton, (String)FormUtils.getBundleString("CTL_CW_Property"));
        Mnemonics.setLocalizedText((AbstractButton)this.methodButton, (String)FormUtils.getBundleString("CTL_CW_Method"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeButton, (String)FormUtils.getBundleString("CTL_CW_UserCode"));
        this.beansList = new ArrayList<RADComponent>();
        for (RADComponent radComp : formModel.getAllComponents()) {
            if (!this.requiredType.isAssignableFrom(radComp.getBeanClass())) continue;
            this.beansList.add(radComp);
        }
        if (this.beansList.size() > 0) {
            Collections.sort(this.beansList, new ComponentComparator());
            this.beanCombo.addItem(FormUtils.getBundleString("CTL_CW_SelectBean"));
            for (RADComponent radComp : this.beansList) {
                if (radComp == formModel.getTopRADComponent()) {
                    this.beanCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                    continue;
                }
                this.beanCombo.addItem(radComp.getName());
            }
            this.beanCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    int index = ParametersPicker.this.beanCombo.getSelectedIndex();
                    if (index == 0) {
                        ParametersPicker.this.selectedComponent = null;
                    } else {
                        ParametersPicker.this.selectedComponent = (RADComponent)ParametersPicker.this.beansList.get(index - 1);
                    }
                    ParametersPicker.this.fireStateChange();
                }
            });
        } else {
            this.beanButton.setEnabled(false);
        }
        this.updateParameterTypes();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.source.modifying.property");
        this.valueButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Value"));
        this.beanButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Bean"));
        this.propertyButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Property"));
        this.methodButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Method"));
        this.codeButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_UserCode"));
        this.valueField.getAccessibleContext().setAccessibleName(this.valueButton.getText());
        this.valueField.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_ValueField"));
        this.beanCombo.getAccessibleContext().setAccessibleName(this.beanButton.getText());
        this.beanCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_BeanCombo"));
        this.propertyLabel.getAccessibleContext().setAccessibleName(this.propertyButton.getText());
        this.propertyLabel.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyLabel"));
        this.methodLabel.getAccessibleContext().setAccessibleName(this.methodButton.getText());
        this.methodLabel.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodLabel"));
        this.codeArea.getAccessibleContext().setAccessibleName(this.codeButton.getText());
        this.codeArea.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_UserCodeArea"));
        this.propertyDetailsButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyButton"));
        this.methodDetailsButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodButton"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ParametersPicker"));
    }

    public void setPropertyValue(RADConnectionPropertyEditor.RADConnectionDesignValue value, Object realValue) {
        if (value == null) {
            this.previousValue = realValue != null;
            return;
        }
        this.previousValue = true;
        switch (value.type) {
            case 3: {
                this.valueButton.setSelected(true);
                this.valueField.setText(value.value);
                break;
            }
            case 4: {
                this.beanButton.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                int index = this.beansList.indexOf(this.selectedComponent);
                if (index <= -1) break;
                this.beanCombo.setSelectedIndex(index + 1);
                break;
            }
            case 0: {
                this.propertyButton.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                this.selectedProperty = value.getProperty();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.propertyLabel.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.propertyLabel.setText(this.selectedProperty.getName());
                } else {
                    this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
                }
                this.propertyLabel.selectAll();
                break;
            }
            case 1: {
                this.methodButton.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                this.selectedMethod = value.getMethod();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.methodLabel.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.methodLabel.setText(this.selectedMethod.getName());
                } else {
                    this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
                }
                this.methodLabel.selectAll();
                break;
            }
            default: {
                this.codeButton.setSelected(true);
                this.codeArea.setText(value.userCode);
            }
        }
        this.updateParameterTypes();
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.valueButton.isSelected() && !"".equals(this.valueField.getText())) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.requiredType, this.valueField.getText());
        }
        if (this.beanButton.isSelected() && this.selectedComponent != null) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent);
        }
        if (this.codeButton.isSelected() && !"".equals(this.codeArea.getText())) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codeArea.getText());
        }
        if (this.propertyButton.isSelected() && this.selectedProperty != null) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedProperty);
        }
        if (this.methodButton.isSelected() && this.selectedMethod != null) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedMethod);
        }
        if (!this.previousValue) {
            return BeanSupport.NO_VALUE;
        }
        IllegalStateException exc = new IllegalStateException();
        ErrorManager.getDefault().annotate((Throwable)exc, 256, null, FormUtils.getBundleString("ERR_NothingEntered"), null, null);
        throw exc;
    }

    public String getPreviewText() {
        if (!this.isFilled()) {
            return FormUtils.getBundleString("CTL_CW_NotSet");
        }
        if (this.codeButton.isSelected()) {
            return FormUtils.getBundleString("CTL_CW_Code");
        }
        return this.getText();
    }

    public String getText() {
        if (!this.isFilled()) {
            return FormUtils.getBundleString("CTL_CW_NotSet");
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(String.class)) {
                String s = this.valueField.getText();
                s = s.replace("\\", "\\\\");
                s = s.replace("\"", "\\\"");
                return "\"" + s + "\"";
            }
            return this.valueField.getText() != null ? this.valueField.getText() : "";
        }
        if (this.codeButton.isSelected()) {
            return this.codeArea.getText();
        }
        if (this.beanButton.isSelected()) {
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                return "this";
            }
            return this.selectedComponent.getName();
        }
        if (this.propertyButton.isSelected()) {
            StringBuilder sb = new StringBuilder();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                sb.append(this.selectedComponent.getName());
                sb.append(".");
            }
            if (this.selectedProperty != null) {
                sb.append(this.selectedProperty.getReadMethod().getName());
                sb.append("()");
            } else {
                sb.append("???");
            }
            return sb.toString();
        }
        if (this.methodButton.isSelected()) {
            StringBuilder sb = new StringBuilder();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                sb.append(this.selectedComponent.getName());
                sb.append(".");
            }
            sb.append(this.selectedMethod.getName());
            sb.append("()");
            return sb.toString();
        }
        return "";
    }

    public boolean isFilled() {
        if (this.codeButton.isSelected()) {
            if (this.requiredType.equals(String.class)) {
                return true;
            }
            return !"".equals(this.codeArea.getText());
        }
        if (this.beanButton.isSelected()) {
            return this.selectedComponent != null;
        }
        if (this.propertyButton.isSelected()) {
            return this.selectedProperty != null;
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(String.class)) {
                return true;
            }
            return !"".equals(this.valueField.getText());
        }
        if (this.methodButton.isSelected()) {
            return this.selectedMethod != null;
        }
        return false;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(l);
    }

    public synchronized void removeListener(ChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private synchronized void fireStateChange() {
        if (this.listeners == null) {
            return;
        }
        ArrayList<ChangeListener> list = new ArrayList<ChangeListener>(this.listeners);
        ChangeEvent evt = new ChangeEvent(this);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(evt);
        }
    }

    private void initComponents() {
        this.valueButton = new JRadioButton();
        this.valueField = new JTextField();
        this.beanButton = new JRadioButton();
        this.beanCombo = new JComboBox();
        this.propertyButton = new JRadioButton();
        this.propertyLabel = new JTextField();
        this.propertyDetailsButton = new JButton();
        this.methodButton = new JRadioButton();
        this.methodLabel = new JTextField();
        this.methodDetailsButton = new JButton();
        this.codeButton = new JRadioButton();
        this.codeScrollPane = new JScrollPane();
        this.codeArea = FormEditor.createCodeEditorPane(this.formModel);
        this.paramLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.valueButton.setText("Value:");
        this.valueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.valueButton, gridBagConstraints);
        this.valueField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ParametersPicker.this.updateState(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.valueField, gridBagConstraints);
        this.beanButton.setText("Bean:");
        this.beanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.beanButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.beanCombo, gridBagConstraints);
        this.propertyButton.setText("Property:");
        this.propertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.propertyButton, gridBagConstraints);
        this.propertyLabel.setEditable(false);
        this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.propertyLabel, gridBagConstraints);
        this.propertyDetailsButton.setText("...");
        this.propertyDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.propertyDetailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.propertyDetailsButton, gridBagConstraints);
        this.methodButton.setText("Method Call:");
        this.methodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.methodButton, gridBagConstraints);
        this.methodLabel.setEditable(false);
        this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.methodLabel, gridBagConstraints);
        this.methodDetailsButton.setText("...");
        this.methodDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.methodDetailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.methodDetailsButton, gridBagConstraints);
        this.codeButton.setText("User Code:");
        this.codeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPicker.this.typeButtonPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.codeButton, gridBagConstraints);
        this.codeArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ParametersPicker.this.codeAreaMouseClicked(evt);
            }
        });
        this.codeArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ParametersPicker.this.updateState(evt);
            }
        });
        this.codeScrollPane.setViewportView(this.codeArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.codeScrollPane, gridBagConstraints);
        this.paramLabel.setText(FormUtils.getBundleString("CTL_CW_GetParametersFrom"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
    }

    private void codeAreaMouseClicked(MouseEvent evt) {
        if (!this.codeButton.isSelected()) {
            this.codeButton.doClick();
        }
    }

    private void methodDetailsButtonActionPerformed(ActionEvent evt) {
        MethodPicker picker = new MethodPicker(this.formModel, null, this.requiredType);
        picker.setSelectedComponent(this.selectedComponent);
        picker.setSelectedMethod(this.selectedMethod);
        String title = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectMethod", Utilities.getShortClassName(this.requiredType));
        final DialogDescriptor dd = new DialogDescriptor((Object)picker, title);
        dd.setValid(picker.isPickerValid());
        picker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt2) {
                dd.setValid(((Boolean)evt2.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = picker.getSelectedComponent();
            MethodPicker.MethodPickerItem selectedItem = picker.getSelectedMethod();
            this.selectedMethod = selectedItem.getMethodDescriptor();
            if (this.selectedMethod == null) {
                this.switchToCodeArea(selectedItem.getMethodName());
                return;
            }
            this.methodLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.methodLabel.setText(this.selectedMethod.getName());
            } else {
                this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
            this.methodLabel.repaint();
            this.fireStateChange();
        }
    }

    private void updateState(CaretEvent evt) {
        this.fireStateChange();
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
    }

    private void propertyDetailsButtonActionPerformed(ActionEvent evt) {
        if (this.propertyPicker == null) {
            this.propertyPicker = new PropertyPicker(this.formModel, null, this.requiredType);
        }
        this.propertyPicker.setSelectedComponent(this.selectedComponent);
        this.propertyPicker.setSelectedProperty(this.selectedProperty);
        String title = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectProperty", Utilities.getShortClassName(this.requiredType));
        final DialogDescriptor dd = new DialogDescriptor((Object)this.propertyPicker, title);
        dd.setValid(this.propertyPicker.isPickerValid());
        this.propertyPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt2) {
                dd.setValid(((Boolean)evt2.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = this.propertyPicker.getSelectedComponent();
            PropertyPicker.PropertyPickerItem selectedItem = this.propertyPicker.getSelectedProperty();
            this.selectedProperty = selectedItem.getPropertyDescriptor();
            if (this.selectedProperty == null) {
                this.switchToCodeArea(selectedItem.getReadMethodName());
                return;
            }
            this.propertyLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.propertyLabel.setText(this.selectedProperty.getName());
            } else {
                this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
            }
            this.propertyLabel.repaint();
            this.fireStateChange();
        }
    }

    private void switchToCodeArea(String text) {
        this.codeArea.setText(text);
        this.codeButton.setSelected(true);
        this.updateParameterTypes();
    }

    private void typeButtonPressed(ActionEvent evt) {
        this.updateParameterTypes();
        if (this.beanButton.isSelected()) {
            this.beanCombo.requestFocus();
        } else if (this.codeButton.isSelected()) {
            this.codeArea.requestFocus();
        } else if (this.propertyButton.isSelected()) {
            this.propertyDetailsButton.requestFocus();
        } else if (this.methodButton.isSelected()) {
            this.methodDetailsButton.requestFocus();
        } else if (this.valueButton.isSelected()) {
            this.valueField.requestFocus();
        }
    }

    private void updateParameterTypes() {
        this.valueField.setEnabled(this.valueButton.isSelected());
        this.beanCombo.setEnabled(this.beanButton.isSelected());
        if (!this.propertyButton.isSelected()) {
            this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        }
        this.propertyLabel.setEnabled(this.propertyButton.isSelected());
        this.propertyLabel.repaint();
        this.propertyDetailsButton.setEnabled(this.propertyButton.isSelected());
        if (!this.methodButton.isSelected()) {
            this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        }
        this.methodLabel.setEnabled(this.methodButton.isSelected());
        this.methodLabel.repaint();
        this.methodDetailsButton.setEnabled(this.methodButton.isSelected());
        this.codeArea.setEnabled(this.codeButton.isSelected());
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
        this.fireStateChange();
    }

    static class ComponentComparator
    implements Comparator<RADComponent> {
        ComponentComparator() {
        }

        @Override
        public int compare(RADComponent comp1, RADComponent comp2) {
            if (comp1 == comp2) {
                return 0;
            }
            RADComponent topComp = comp1.getFormModel().getTopRADComponent();
            if (comp1 == topComp) {
                return -1;
            }
            if (comp2 == topComp) {
                return 1;
            }
            return comp1.getName().compareTo(comp2.getName());
        }
    }
}

