/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.codeception.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.codeception.commands.Codecept;
import org.netbeans.modules.php.codeception.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class CodeceptionOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CodeceptionOptionsPanel.class.getName());
    private static final String CODECEPTION_LAST_FOLDER_SUFFIX = ".codeception";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseButton;
    private JLabel codeceptionHintLabel;
    private JLabel codeceptionLabel;
    private JTextField codeceptionTextField;
    private JLabel errorLabel;
    private JLabel installLabel;
    private JLabel learnMoreLabel;
    private JLabel minVersionLabel;
    private JLabel noteLabel;
    private JButton searchButton;

    CodeceptionOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.codeceptionHintLabel.setText(Bundle.CodeceptionOptionsPanel_codeception_hint("codecept", Codecept.SCRIPT_NAME_LONG, "codecept.phar"));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.codeceptionTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public String getCodeception() {
        return this.codeceptionTextField.getText();
    }

    public void setCodeception(String codeception) {
        this.codeceptionTextField.setText(codeception);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.codeceptionLabel = new JLabel();
        this.codeceptionTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        this.codeceptionHintLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.minVersionLabel = new JLabel();
        this.installLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.codeceptionLabel.setLabelFor(this.codeceptionTextField);
        Mnemonics.setLocalizedText((JLabel)this.codeceptionLabel, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.codeceptionLabel.text"));
        this.codeceptionLabel.setToolTipText(NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.codeceptionLabel.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeceptionOptionsPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeceptionOptionsPanel.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.codeceptionHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.minVersionLabel, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.minVersionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.installLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(CodeceptionOptionsPanel.class, (String)"CodeceptionOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CodeceptionOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CodeceptionOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.codeceptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.codeceptionHintLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.codeceptionTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.learnMoreLabel, -2, -1, -2).addComponent(this.minVersionLabel).addComponent(this.installLabel)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codeceptionLabel).addComponent(this.codeceptionTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.searchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeceptionHintLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CodeceptionOptionsPanel.class.getName() + CODECEPTION_LAST_FOLDER_SUFFIX).setFilesOnly(true).setTitle(Bundle.CodeceptionOptionsPanel_codeception_browse_title()).showOpenDialog();
        if (file != null) {
            this.codeceptionTextField.setText(file.getAbsolutePath());
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String codeception = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"codecept", Codecept.SCRIPT_NAME_LONG, "codecept.phar"});
            }

            public String getWindowTitle() {
                return Bundle.CodeceptionOptionsPanel_codeception_search_title();
            }

            public String getListTitle() {
                return Bundle.CodeceptionOptionsPanel_codeception_search_files();
            }

            public String getPleaseWaitPart() {
                return Bundle.CodeceptionOptionsPanel_codeception_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.CodeceptionOptionsPanel_codeception_search_notFound();
            }
        });
        if (codeception != null) {
            this.codeceptionTextField.setText(codeception);
        }
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://codeception.com/");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CodeceptionOptionsPanel.this.fireChange();
        }
    }
}

