/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.actions;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public abstract class FileNode
extends DefaultMutableTreeNode {
    private boolean selected = true;

    public FileNode(Object userObject) {
        super(userObject, true);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.setSelected(selected, true);
    }

    private void setSelected(boolean selected, boolean completeTree) {
        this.selected = selected;
        if (completeTree) {
            TreeNode[] path = this.getPath();
            for (int i = path.length - 2; i >= 0; --i) {
                TreeNode tn = path[i];
                if (!(tn instanceof FileNode)) continue;
                FileNode fn = (FileNode)tn;
                if (this.containsSelected(fn) && !selected) break;
                fn.setSelected(selected, false);
            }
            this.selectChildren(this, selected);
        }
    }

    private void selectChildren(FileNode node, boolean selected) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            FileNode child = (FileNode)node.getChildAt(i);
            child.setSelected(selected);
            this.selectChildren(child, selected);
        }
    }

    abstract VCSFileProxy getFile();

    abstract String getText();

    abstract String getTooltip();

    private boolean containsSelected(FileNode fn) {
        for (int i = 0; i < fn.getChildCount(); ++i) {
            TreeNode child = fn.getChildAt(i);
            if (!(child instanceof FileNode) || !((FileNode)child).isSelected()) continue;
            return true;
        }
        return false;
    }

    static class PlainFileNode
    extends FileNode {
        public PlainFileNode(VCSFileProxy root) {
            super(root);
        }

        @Override
        VCSFileProxy getFile() {
            return (VCSFileProxy)this.userObject;
        }

        @Override
        String getText() {
            return this.getFile().getName();
        }

        @Override
        String getTooltip() {
            return this.getFile().getName();
        }
    }

    static class StoreEntryNode
    extends FileNode {
        public StoreEntryNode(StoreEntry storeEntry) {
            super(storeEntry);
        }

        @Override
        VCSFileProxy getFile() {
            return this.getStoreEntry().getFile();
        }

        StoreEntry getStoreEntry() {
            return (StoreEntry)this.userObject;
        }

        @Override
        String getText() {
            return this.getFile().getName();
        }

        @Override
        String getTooltip() {
            return "Revert " + this.getFile();
        }
    }
}

