/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.actions;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.ui.FixedWatchesManager;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToSourceAction;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class CreateFixedWatchAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(GoToSourceAction.class, (String)"CTL_CreateFixedWatch");
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = false;
        for (Node n : activatedNodes) {
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci == null) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci == null) continue;
            this.addFixedWatch(ci);
        }
    }

    private void addFixedWatch(JavaComponentInfo ci) {
        JPDADebuggerImpl debugger = ci.getThread().getDebugger();
        List list = debugger.getSession().lookup("WatchesView", NodeActionsProviderFilter.class);
        FixedWatchesManager fwman = null;
        for (Object obj : list) {
            if (!(obj instanceof FixedWatchesManager)) continue;
            fwman = (FixedWatchesManager)obj;
            break;
        }
        if (fwman != null) {
            ObjectReference component = ci.getComponent();
            fwman.addFixedWatch(ci.getDisplayName(), debugger.getVariable((Value)component));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateFixedWatchAction.class);
    }
}

