/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

public abstract class BaseProjectPathSupport
extends BasePathSupport {
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper referenceHelper;
    private final AntProjectHelper antProjectHelper;

    public BaseProjectPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper) {
        assert (evaluator != null);
        assert (referenceHelper != null);
        assert (antProjectHelper != null);
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
    }

    protected abstract boolean isWellKnownPath(String var1);

    public Iterator<BasePathSupport.Item> itemsIterator(String propertyValue) {
        return this.itemsList(propertyValue).iterator();
    }

    public Iterator<BasePathSupport.Item> itemsIterator(String ... propertyValues) {
        return this.itemsList(propertyValues).iterator();
    }

    public List<BasePathSupport.Item> itemsList(String propertyValue) {
        return this.itemsList(PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue)));
    }

    public List<BasePathSupport.Item> itemsList(String ... values) {
        ArrayList<BasePathSupport.Item> items = new ArrayList<BasePathSupport.Item>(values.length);
        for (String p : values) {
            BasePathSupport.Item item;
            if (this.isWellKnownPath(p)) {
                item = BasePathSupport.Item.create(p);
            } else {
                File f = null;
                String eval = this.evaluator.evaluate(p);
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? BasePathSupport.Item.createBroken(eval, p) : BasePathSupport.Item.create(eval, p);
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator<BasePathSupport.Item> classpath) {
        return this.encodeToStrings(classpath, true);
    }

    public String[] encodeToStrings(Iterator<BasePathSupport.Item> classpath, boolean createReferences) {
        return this.encodeToStrings(classpath, createReferences, true);
    }

    public String[] encodeToStrings(Iterator<BasePathSupport.Item> classpath, boolean createReferences, boolean withPathSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        while (classpath.hasNext()) {
            BasePathSupport.Item item = classpath.next();
            String reference = item.getReference();
            switch (item.getType()) {
                case FOLDER: {
                    if (reference != null) break;
                    File file = new File(item.getFilePath());
                    reference = createReferences ? this.referenceHelper.createForeignFileReference(file, null) : file.getPath();
                    item.property = reference;
                    break;
                }
                case CLASSPATH: {
                    break;
                }
                default: {
                    assert (false) : "Unknown classpath type: " + (Object)((Object)item.getType());
                    break;
                }
            }
            if (reference == null) continue;
            result.add(reference);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = withPathSeparator && i < result.size() - 1 ? (String)result.get(i) + ":" : (String)result.get(i);
        }
        return items;
    }
}

