/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.netbeans.modules.php.project.ui.Utils;

public class HintArea
extends JTextPane {
    private static final long serialVersionUID = 76873543674545L;

    public HintArea() {
        Color hintBackground = Utils.getHintBackground();
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setFont(UIManager.getFont("Label.font"));
        this.setBackground(hintBackground);
        this.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, hintBackground));
        this.setContentType("text/html");
        this.setEditable(false);
    }

    @Override
    public void setText(String value) {
        if (value == null) {
            return;
        }
        Font font = this.getFont();
        Color textColor = this.getForeground();
        value = value.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        value = value.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        String colorText = "rgb(" + textColor.getRed() + "," + textColor.getGreen() + "," + textColor.getBlue() + ")";
        String newText = "<html><body style=\"color: " + colorText + "; font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + value + "</body></html>";
        this.setDocument(this.getEditorKit().createDefaultDocument());
        super.setText(newText);
    }
}

