/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.options.OptionsPanelController;

abstract class BaseOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    volatile boolean changed = false;

    BaseOptionsPanelController() {
    }

    protected abstract boolean validateComponent();

    protected abstract void updateInternal();

    protected abstract void applyChangesInternal();

    protected abstract boolean areOptionsChanged();

    public final void update() {
        this.updateInternal();
        this.changed = false;
    }

    public final void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseOptionsPanelController.this.applyChangesInternal();
                BaseOptionsPanelController.this.changed = false;
            }
        });
    }

    public final void cancel() {
        this.changed = false;
    }

    public final boolean isValid() {
        return this.validateComponent();
    }

    public final boolean isChanged() {
        return this.areOptionsChanged();
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public final void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    protected Integer parseInteger(String input) {
        Integer number = null;
        try {
            number = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    protected final PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }
}

