/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.bridge.BridgingServerInstanceProvider;
import org.netbeans.modules.j2ee.deployment.impl.bridge.ServerInstanceProviderLookup;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.netbeans.spi.server.ServerWizardProvider;
import org.openide.WizardDescriptor;

public class BridgingServerWizardProvider
implements ServerWizardProvider {
    private final Server server;
    private final OptionalDeploymentManagerFactory optional;

    public BridgingServerWizardProvider(Server server, OptionalDeploymentManagerFactory optional) {
        this.server = server;
        this.optional = optional;
    }

    public WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        if (this.optional.getAddInstanceIterator() == null) {
            return null;
        }
        return new InstantiatingIteratorBridge(this.optional.getAddInstanceIterator(), this.server);
    }

    public String getDisplayName() {
        return this.server.getDisplayName();
    }

    private static class InstantiatingIteratorBridge
    implements WizardDescriptor.AsynchronousInstantiatingIterator {
        private final WizardDescriptor.InstantiatingIterator iterator;
        private final Server server;

        public InstantiatingIteratorBridge(WizardDescriptor.InstantiatingIterator iterator, Server server) {
            this.iterator = iterator;
            this.server = server;
        }

        public void uninitialize(WizardDescriptor wizard) {
            this.iterator.uninitialize(wizard);
        }

        public Set instantiate() throws IOException {
            HashSet<org.netbeans.api.server.ServerInstance> objects = this.iterator.instantiate();
            if (!objects.isEmpty()) {
                org.netbeans.api.server.ServerInstance instance;
                Object value = objects.iterator().next();
                String url = null;
                if (value instanceof String) {
                    url = (String)value;
                } else if (value instanceof InstanceProperties) {
                    url = ((InstanceProperties)value).getProperty("url");
                }
                if (url != null && (instance = this.getBridge(ServerRegistry.getInstance().getServerInstance(url))) != null) {
                    objects = new HashSet<org.netbeans.api.server.ServerInstance>();
                    objects.add(instance);
                }
            }
            return objects;
        }

        public void initialize(WizardDescriptor wizard) {
            this.iterator.initialize(wizard);
        }

        public void removeChangeListener(ChangeListener l) {
            this.iterator.removeChangeListener(l);
        }

        public void previousPanel() {
            this.iterator.previousPanel();
        }

        public void nextPanel() {
            this.iterator.nextPanel();
        }

        public String name() {
            return this.iterator.name();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public WizardDescriptor.Panel current() {
            return this.iterator.current();
        }

        public void addChangeListener(ChangeListener l) {
            this.iterator.addChangeListener(l);
        }

        private org.netbeans.api.server.ServerInstance getBridge(ServerInstance instance) {
            Collection providers = ServerInstanceProviderLookup.getInstance().lookupAll(ServerInstanceProvider.class);
            for (ServerInstanceProvider provider : providers) {
                org.netbeans.api.server.ServerInstance bridgingInstance;
                if (!(provider instanceof BridgingServerInstanceProvider) || (bridgingInstance = ((BridgingServerInstanceProvider)provider).getBridge(instance)) == null) continue;
                return bridgingInstance;
            }
            return null;
        }
    }
}

