/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.deployment.impl.ui.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class RenamePanel
extends JPanel
implements DocumentListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final String serverName;
    private JLabel errorMessage;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel renameLabel;

    public RenamePanel(String name) {
        this.serverName = name;
        this.initComponents();
        this.nameTextField.setText(name);
        this.nameTextField.getDocument().addDocumentListener(this);
        this.validateDialog();
    }

    public String getServerName() {
        return this.nameTextField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateDialog();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateDialog();
    }

    public boolean isPanelValid() {
        return " ".equals(this.errorMessage.getText());
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private void validateDialog() {
        String newError = this.computeError();
        boolean changed = false;
        String currentError = this.errorMessage.getText();
        newError = newError != null ? newError : " ";
        changed = !currentError.equals(newError);
        this.errorMessage.setText(newError);
        if (changed) {
            this.changeSupport.fireChange();
        }
    }

    private String computeError() {
        if (this.nameTextField == null || this.nameTextField.getText().isEmpty()) {
            return Bundle.MSG_ErrorEmptyName();
        }
        return null;
    }

    private void initComponents() {
        this.renameLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.errorMessage = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.renameLabel, (String)NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.renameLabel.text", (Object[])new Object[]{this.serverName}));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.nameLabel.text"));
        this.nameTextField.setColumns(30);
        this.errorMessage.setForeground(UIManager.getColor("nb.errorForeground"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.renameLabel).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nameTextField, -1, 287, Short.MAX_VALUE)).addComponent(this.errorMessage));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.renameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errorMessage)));
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RenamePanel.class, (String)"RenamePanel.nameTextField.AccessibleContext.accessibleName", (Object[])new Object[0]));
    }
}

