/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class GradleCompilerOptionsQuery
implements CompilerOptionsQueryImplementation {
    final Project project;
    private final PropertyChangeListener listener;
    final Map<String, ResultImpl> cache = new HashMap<String, ResultImpl>();

    public GradleCompilerOptionsQuery(Project project) {
        this.project = project;
        NbGradleProject watcher = NbGradleProject.get((Project)project);
        this.listener = evt -> {
            if (watcher.isUnloadable()) {
                return;
            }
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                GradleCompilerOptionsQuery gradleCompilerOptionsQuery = this;
                synchronized (gradleCompilerOptionsQuery) {
                    for (ResultImpl res : this.cache.values()) {
                        res.changeCheck();
                    }
                }
            }
        };
        watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        File f = FileUtil.toFile((FileObject)file);
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        GradleJavaSourceSet sourceSet = gjp.containingSourceSet(f);
        ResultImpl ret = null;
        if (sourceSet != null) {
            GradleJavaSourceSet.SourceType sourceType = sourceSet.getSourceType(f);
            if (sourceType == GradleJavaSourceSet.SourceType.GENERATED) {
                sourceType = GradleJavaSourceSet.SourceType.JAVA;
            }
            if (sourceType != null && sourceType != GradleJavaSourceSet.SourceType.RESOURCES) {
                String key = sourceSet.getName() + "." + sourceType.name();
                GradleCompilerOptionsQuery gradleCompilerOptionsQuery = this;
                synchronized (gradleCompilerOptionsQuery) {
                    ret = this.cache.get(key);
                    if (ret == null) {
                        ret = new ResultImpl(sourceSet.getName(), sourceType);
                        this.cache.put(key, ret);
                    }
                }
            }
        }
        return ret;
    }

    final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result {
        final String sourceSetName;
        final GradleJavaSourceSet.SourceType type;
        final ChangeSupport support;
        List<String> args;

        public ResultImpl(String sourceSetName, GradleJavaSourceSet.SourceType type) {
            this.sourceSetName = sourceSetName;
            this.type = type;
            this.support = new ChangeSupport((Object)this);
            this.args = this.checkArgs();
        }

        public synchronized List<? extends String> getArguments() {
            return this.args;
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        private List<String> checkArgs() {
            GradleJavaProject gjp = GradleJavaProject.get(GradleCompilerOptionsQuery.this.project);
            GradleJavaSourceSet ss = gjp != null ? gjp.getSourceSets().get(this.sourceSetName) : null;
            return ss != null ? ss.getCompilerArgs(this.type) : Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeCheck() {
            boolean modified = false;
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                List<String> newArgs = this.checkArgs();
                if (!this.args.equals(newArgs)) {
                    this.args = newArgs;
                    modified = true;
                }
            }
            if (modified) {
                this.support.fireChange();
            }
        }
    }
}

