/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jquery;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.javascript2.jquery.SelectorItem;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SelectorsLoader
extends DefaultHandler {
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String SELECTOR = "selector";
    public static final String METHOD = "method";
    public static final String RETURN = "return";
    private static final Color PRE_BACKGROUNDCOLOR = new Color(254, 254, 202);
    private static final Color TITLE_BACKGROUNDCOLOR = new Color(31, 111, 180);
    private static final Color TITLE_COLOR = Color.WHITE;
    private static final Color LINK_COLOR = Color.WHITE;
    private static final Color TABLE_BACKGROUNDCOLOR = new Color(209, 209, 209);
    private static final Color SIGNATURE_COLOR = new Color(102, 102, 102);
    private static final Color SIGNATURE_VERSION = new Color(93, 176, 230);
    private static final Logger LOGGER = Logger.getLogger(SelectorsLoader.class.getName());
    private static List<SelectorItem> result = new ArrayList<SelectorItem>();
    private boolean inSelector = false;
    private String name;
    private String sample;
    private Tag inTag = Tag.notinterested;

    private SelectorsLoader() {
    }

    public static Collection<SelectorItem> getSelectors(File file) {
        result.clear();
        try {
            long start = System.currentTimeMillis();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            SelectorsLoader handler = new SelectorsLoader();
            parser.parse(file, (DefaultHandler)handler);
            long end = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "Loading selectors from API file took {0}ms ", end - start);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public static String getDocumentation(File file, String selectorName) {
        DocumentationBuilder documentationBuilder = new DocumentationBuilder(file);
        return documentationBuilder.buildForSelector(selectorName);
    }

    public static String getMethodDocumentation(File file, String name) {
        DocumentationBuilder documentationBuilder = new DocumentationBuilder(file);
        return documentationBuilder.buildForMethod(name);
    }

    public static void addToModel(File apiFile, ModelElementFactory elementFactory, JsObject jQuery) {
        JQueryModelBuilder propertiesBuilder = new JQueryModelBuilder(apiFile, jQuery, elementFactory);
        propertiesBuilder.addProperties(jQuery);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String type;
        if (this.inSelector) {
            if (qName.equals(Tag.sample.name())) {
                this.inTag = Tag.sample;
            }
        } else if (qName.equals(Tag.entry.name()) && (type = attributes.getValue(TYPE)).equals(SELECTOR)) {
            this.inSelector = true;
            this.name = attributes.getValue(NAME);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inSelector && qName.equals(Tag.entry.name())) {
            this.inSelector = false;
            String template = null;
            if (this.sample.indexOf(40) > -1) {
                template = this.name + "(${cursor})";
                this.name = this.name + "()";
            }
            SelectorItem item = new SelectorItem(this.name, template);
            result.add(item);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inTag == Tag.sample) {
            this.sample = new String(ch, start, length);
            this.inTag = Tag.notinterested;
        }
    }

    private static String getColorString(Color c) {
        return "#" + SelectorsLoader.getHex(c.getRed()) + SelectorsLoader.getHex(c.getGreen()) + SelectorsLoader.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static class JQueryModelBuilder
    extends DefaultHandler {
        private final File file;
        private final JsObject jQuery;
        private final ModelElementFactory elementFactory;
        private final List<Tag> tagPath;
        boolean isMethod;
        boolean isProperty;
        private String name;
        private String returns;
        private String added;
        private final List<String> params;

        public JQueryModelBuilder(File file, JsObject jQuery, ModelElementFactory elementFactory) {
            this.file = file;
            this.jQuery = jQuery;
            this.elementFactory = elementFactory;
            this.tagPath = new ArrayList<Tag>();
            this.params = new ArrayList<String>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Tag current;
            try {
                current = Tag.valueOf(qName);
            }
            catch (IllegalArgumentException iae) {
                current = Tag.notinterested;
            }
            this.tagPath.add(0, current);
            switch (current) {
                case entry: {
                    String type = attributes.getValue(SelectorsLoader.TYPE);
                    if (type.equals(SelectorsLoader.METHOD)) {
                        this.isMethod = true;
                    } else if (type.equals("property")) {
                        this.isProperty = true;
                    }
                    if (!this.isMethod && !this.isProperty) break;
                    this.name = attributes.getValue(SelectorsLoader.NAME);
                    if (this.name.startsWith("jQuery.")) {
                        this.name = this.name.substring(7);
                    }
                    this.returns = attributes.getValue(SelectorsLoader.RETURN);
                    break;
                }
                case argument: {
                    if (!this.isMethod) break;
                    String paramName = attributes.getValue(SelectorsLoader.NAME);
                    this.params.add(paramName);
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.tagPath.size() > 0) {
                Tag current = this.tagPath.remove(0);
                if (this.isMethod) {
                    switch (current) {
                        case signature: {
                            if (this.name.indexOf(46) != -1) break;
                            JsFunction function = this.elementFactory.newFunction((DeclarationScope)this.jQuery, this.jQuery, this.name, this.params);
                            function.addReturnType(this.elementFactory.newType(this.returns, -1, true));
                            this.jQuery.addProperty(this.name + "#" + this.added, (JsObject)function);
                            this.params.clear();
                            break;
                        }
                        case entry: {
                            this.isMethod = false;
                            this.params.clear();
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tagPath.get(0) == Tag.added && this.tagPath.size() > 1 && this.tagPath.get(1) == Tag.signature) {
                this.added = new String(ch, start, length);
            }
        }

        private void addProperties(JsObject global) {
            try {
                long start = System.currentTimeMillis();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(this.file, (DefaultHandler)this);
                long end = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "Collecting properties from jQuery API file took {0}ms ", end - start);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class DocumentationBuilder
    extends DefaultHandler {
        private static final String TABLE_STYLE = "style=\"border: 0px; width: 100%;\"";
        private static final String TD_STYLE = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;\" ";
        private static final String TD_STYLE_MAX_WIDTH = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;width:80%;\" ";
        private StringBuilder documentation;
        private boolean inTag = false;
        private String interestedInTypeTag;
        private String elementName;
        private String elementNameWithPrefix;
        private File file;
        private List<Tag> tagPath;
        private String sample;
        private String returns;
        private String description;
        private List<String> notes;
        private String longDescription;
        private String argName;
        private String argType;
        private List<Signature> signatures;

        public DocumentationBuilder(File file) {
            this.file = file;
            this.tagPath = new ArrayList<Tag>();
        }

        public String buildForMethod(String name) {
            this.documentation = new StringBuilder();
            try {
                long start = System.currentTimeMillis();
                this.elementName = name;
                this.elementNameWithPrefix = "jQuery." + name;
                this.interestedInTypeTag = SelectorsLoader.METHOD;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(this.file, (DefaultHandler)this);
                long end = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "Loading selectors from API file took {0}ms ", end - start);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return this.documentation.toString();
        }

        public String buildForSelector(String name) {
            this.documentation = new StringBuilder();
            try {
                long start = System.currentTimeMillis();
                this.elementName = name;
                this.interestedInTypeTag = SelectorsLoader.SELECTOR;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(this.file, (DefaultHandler)this);
                long end = System.currentTimeMillis();
                LOGGER.log(Level.FINE, "Loading selectors from API file took {0}ms ", end - start);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return this.documentation.toString();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            String type;
            if (this.inTag) {
                Tag current;
                try {
                    current = Tag.valueOf(qName);
                }
                catch (IllegalArgumentException iae) {
                    current = Tag.notinterested;
                }
                this.tagPath.add(0, current);
                switch (current) {
                    case argument: {
                        this.argName = attributes.getValue(SelectorsLoader.NAME);
                        this.argType = attributes.getValue(SelectorsLoader.TYPE);
                        break;
                    }
                    case signature: {
                        this.signatures.add(new Signature());
                        break;
                    }
                }
            } else if (qName.equals(Tag.entry.name()) && (type = attributes.getValue(SelectorsLoader.TYPE)).equals(this.interestedInTypeTag) && ((name = attributes.getValue(SelectorsLoader.NAME)).equals(this.elementName) || name.equals(this.elementNameWithPrefix))) {
                this.tagPath.add(Tag.entry);
                this.returns = attributes.getValue(SelectorsLoader.RETURN);
                this.inTag = true;
                this.description = "";
                this.longDescription = "";
                this.sample = "";
                this.longDescription = "";
                this.notes = new ArrayList<String>();
                this.signatures = new ArrayList<Signature>();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inTag) {
                if (this.tagPath.size() > 0) {
                    Tag removed = this.tagPath.remove(0);
                    switch (removed) {
                        case entry: {
                            this.inTag = false;
                            if (SelectorsLoader.METHOD.equals(this.interestedInTypeTag)) {
                                this.createMethodHtmlDoc();
                                break;
                            }
                            this.createSelectorHtmlDoc();
                            break;
                        }
                    }
                }
                if (!this.tagPath.isEmpty() || qName.equals(Tag.entry.name())) {
                    // empty if block
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inTag && this.tagPath.size() > 0) {
                block0 : switch (this.tagPath.get(0)) {
                    case added: {
                        this.signatures.get((int)(this.signatures.size() - 1)).fromVersion = new String(ch, start, length);
                        break;
                    }
                    case desc: {
                        switch (this.tagPath.get(1)) {
                            case entry: {
                                this.description = new String(ch, start, length);
                                break block0;
                            }
                            case argument: {
                                this.signatures.get((int)(this.signatures.size() - 1)).arguments.add(new Argument(this.argName, this.argType, new String(ch, start, length)));
                                break block0;
                            }
                        }
                        break;
                    }
                    case longdesc: {
                        this.longDescription = new String(ch, start, length);
                        break;
                    }
                    case note: {
                        this.notes.add(new String(ch, start, length));
                        break;
                    }
                    case sample: {
                        this.sample = new String(ch, start, length);
                        break;
                    }
                }
            }
        }

        private void createMethodHtmlDoc() {
            this.htmlDocStart();
            this.htmlDocMethodTitle();
            this.htmlDocDescription();
            this.htmlSignatures();
            this.htmlDocLongDescription();
            this.htmlDocEnd();
        }

        private void createSelectorHtmlDoc() {
            this.htmlDocStart();
            this.htmlDocSelectorTitle();
            this.htmlDocDescription();
            this.htmlDocSelectorSignatures();
            this.htmlDocLongDescription();
            this.htmlDocNotes();
            this.htmlDocEnd();
        }

        private String createSignatureText(Signature signature, boolean link) {
            StringBuilder sb = new StringBuilder();
            sb.append('.');
            if (link) {
                sb.append(String.format("<a style='color: %s' href='http://api.jquery.com/%s/'>%s</a>", SelectorsLoader.getColorString(LINK_COLOR), this.elementName, this.elementName));
            } else {
                sb.append(this.elementName);
            }
            sb.append("( ");
            if (signature.arguments.isEmpty()) {
                sb.append(")");
            } else {
                boolean addComma = false;
                for (Argument argument : signature.arguments) {
                    if (addComma) {
                        sb.append(", ");
                    } else {
                        addComma = true;
                    }
                    sb.append(argument.name);
                }
                sb.append(" )");
            }
            return sb.toString();
        }

        private String addStyles(String text) {
            String result = text.replace("<pre>", "<pre style='margin: 1em 0px; display: block; font-family: monospace;white-space: pre;background-color: " + SelectorsLoader.getColorString(PRE_BACKGROUNDCOLOR) + "; padding:6px;'>");
            return result;
        }

        private void htmlDocStart() {
            this.documentation.append("<html>\n");
            this.documentation.append("<head>\n");
            this.documentation.append("</head>\n");
            this.documentation.append("<body style='font-family: Arial; font-size: 11px'>\n");
        }

        private void htmlDocEnd() {
            this.documentation.append("</body>\n");
            this.documentation.append("</html>\n");
        }

        private void htmlDocMethodTitle() {
            this.documentation.append("<table style='width:100%; background-color:").append(SelectorsLoader.getColorString(TITLE_BACKGROUNDCOLOR)).append("; color:").append(SelectorsLoader.getColorString(TITLE_COLOR)).append("; margin:0px; padding:3px;font-weight: bold; font-size: 12px'><tr>\n");
            String firstSignature = this.signatures.isEmpty() ? String.format(".<a style='color: %s' href='http://api.jquery.com/%s/'>%s</a>( )", SelectorsLoader.getColorString(LINK_COLOR), this.elementName, this.elementName) : this.createSignatureText(this.signatures.get(0), true);
            this.documentation.append("<td>").append(firstSignature).append("</td>\n");
            this.documentation.append("<td style='text-align: right;font-style: italic;'>").append(String.format("Returns: <a style='color:%s' href='http://api.jquery.com/Types/#'%s> %s</a>", SelectorsLoader.getColorString(LINK_COLOR), this.returns, this.returns)).append("</td>\n");
            this.documentation.append("</tr></table>");
        }

        private void htmlDocSelectorTitle() {
            this.documentation.append("<table style='width:100%; background-color:").append(SelectorsLoader.getColorString(TITLE_BACKGROUNDCOLOR)).append("; color:").append(SelectorsLoader.getColorString(TITLE_COLOR)).append("; margin:0px; padding:3px;font-weight: bold; font-size: 12px'><tr>\n");
            String title = String.format("<a style='color: %s' href='http://api.jquery.com/%s-selector/'>%s</a> selector", SelectorsLoader.getColorString(LINK_COLOR), this.elementName, this.elementName);
            this.documentation.append("<td>").append(title).append("</td>\n");
            this.documentation.append("</tr></table>");
        }

        private void htmlDocDescription() {
            if (this.description != null && !this.description.isEmpty()) {
                this.documentation.append("<div style='margin: 6px'>\n");
                this.documentation.append(this.description);
                this.documentation.append("</div> \n");
            }
        }

        private void htmlDocLongDescription() {
            if (this.longDescription != null && !this.longDescription.isEmpty()) {
                this.documentation.append("<div style='margin: 6px'>\n");
                this.documentation.append(this.addStyles(this.longDescription));
                this.documentation.append("</div> \n");
            }
        }

        private void htmlDocNotes() {
            if (!this.notes.isEmpty()) {
                this.documentation.append("<p style='font-size: 12px'>\n");
                this.documentation.append("<span style='font-weight: bold'>Additional Notes: </span>\n");
                this.documentation.append("<ul>\n");
                for (String note : this.notes) {
                    this.documentation.append("<li>").append(note).append("</li>\n");
                }
                this.documentation.append("</ul>\n");
                this.documentation.append("</p> \n");
            }
        }

        private void htmlSignatures() {
            if (!this.signatures.isEmpty()) {
                this.documentation.append("<table align='right' style='width:95%; background-color:").append(SelectorsLoader.getColorString(TABLE_BACKGROUNDCOLOR)).append("; padding:12px;margin-right:6px;'><tr><td>");
                for (Signature signature : this.signatures) {
                    this.documentation.append("<table width='100%' style='font-weight: bold;font-size: small; color:").append(SelectorsLoader.getColorString(SIGNATURE_COLOR)).append("'><tr>\n");
                    this.documentation.append("<td>");
                    this.documentation.append(this.createSignatureText(signature, false));
                    this.documentation.append("</td><td style='vertical-align: bottom; text-align: right;'>");
                    this.documentation.append(String.format("version added: <a style='color: %s' href='http://api.jquery.com/category/version/%s/'>%s</a>", SelectorsLoader.getColorString(SIGNATURE_VERSION), signature.fromVersion, signature.fromVersion));
                    this.documentation.append("</td>");
                    this.documentation.append("</tr></table>\n");
                    this.documentation.append("<hr style='width: 100%; height: 2px'/>");
                    for (Argument argument : signature.arguments) {
                        this.documentation.append("<p style='font-size: small; margin-bottom:6px'>");
                        this.documentation.append("<b>").append(argument.name).append("</b>: ");
                        this.documentation.append(argument.description);
                        this.documentation.append("</p>");
                    }
                }
                this.documentation.append("</td></tr></table>");
            }
        }

        private void htmlDocSelectorSignatures() {
            if (!this.signatures.isEmpty()) {
                this.documentation.append("<table align='right' style='width:95%; background-color:").append(SelectorsLoader.getColorString(TABLE_BACKGROUNDCOLOR)).append("; padding:12px;margin-right:6px;'><tr><td>");
                for (Signature signature : this.signatures) {
                    this.documentation.append("<table width='100%' style='font-weight: bold;font-size: small; color:").append(SelectorsLoader.getColorString(SIGNATURE_COLOR)).append("'><tr>\n");
                    this.documentation.append("<td>");
                    this.documentation.append(String.format("jQuery('%s')", this.sample));
                    this.documentation.append("</td><td style='vertical-align: bottom; text-align: right;'>");
                    this.documentation.append(String.format("version added: <a style='color: %s' href='http://api.jquery.com/category/version/%s/'>%s</a>", SelectorsLoader.getColorString(SIGNATURE_VERSION), signature.fromVersion, signature.fromVersion));
                    this.documentation.append("</td>");
                    this.documentation.append("</tr></table>\n");
                    this.documentation.append("<hr style='width: 100%; height: 2px'/>");
                    for (Argument argument : signature.arguments) {
                        this.documentation.append("<p style='font-size: small; margin-bottom:6px'>");
                        this.documentation.append("<b>").append(argument.name).append("</b>: ");
                        this.documentation.append(argument.description);
                        this.documentation.append("</p>");
                    }
                }
                this.documentation.append("</td></tr></table>");
            }
        }
    }

    private static class Argument {
        final String name;
        final String description;

        public Argument(String name, String type, String description) {
            this.name = name;
            this.description = description;
        }
    }

    private static class Signature {
        List<Argument> arguments = new ArrayList<Argument>();
        String fromVersion = null;
    }

    private static enum Tag {
        added,
        argument,
        desc,
        entry,
        longdesc,
        note,
        sample,
        signature,
        notinterested;

    }
}

