/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.concurrent.Callable;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.Bundle;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class PropertyElementItem
extends AbstractCompletionItem {
    private String propertyType;
    private boolean primitive;
    private boolean attribute;
    private boolean inherited;
    private boolean system;
    private boolean map;
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/property.png";
    private static final String MAP_ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/map-property.png";
    private static final String SYSTEM_ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/system-property.png";
    private static ImageIcon ICON;
    private static ImageIcon MAP_ICON;
    private static ImageIcon SYSTEM_ICON;
    private Callable<String> namespaceCreator;

    public PropertyElementItem(CompletionContext ctx, String text, boolean attribute) {
        super(ctx, text);
        this.attribute = attribute;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public void setMap(boolean map) {
        this.map = map;
    }

    public void setNamespaceCreator(Callable<String> namespaceCreator) {
        this.namespaceCreator = namespaceCreator;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    @Override
    protected String getLeftHtmlText() {
        if (!this.inherited) {
            return Bundle.FMT_ownProperty(super.getLeftHtmlText());
        }
        return super.getLeftHtmlText();
    }

    @Override
    protected void doSubstituteText(JTextComponent c, BaseDocument d, String text) throws BadLocationException {
        if (this.namespaceCreator != null) {
            try {
                String s = this.namespaceCreator.call();
                if (!"fx".equals(s)) {
                    text = text.replace("fx:", s + ":");
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        super.doSubstituteText(c, d, text);
    }

    @Override
    protected String getSubstituteText() {
        boolean replaceExisting = this.ctx.isReplaceExisting();
        if (this.attribute) {
            if (replaceExisting) {
                return super.getSubstituteText();
            }
            return super.getSubstituteText() + "=\"\" ";
        }
        if (this.map) {
            if (replaceExisting) {
                return "<" + super.getSubstituteText();
            }
            return "<" + super.getSubstituteText() + " />";
        }
        if (replaceExisting) {
            return "<" + super.getSubstituteText();
        }
        return "<" + super.getSubstituteText() + "></" + super.getSubstituteText() + ">";
    }

    @Override
    protected int getCaretShift(Document d) {
        return 2 + super.getSubstituteText().length();
    }

    @Override
    protected String getRightHtmlText() {
        if (this.propertyType == null) {
            return null;
        }
        return NbBundle.getMessage(PropertyElementItem.class, (String)(this.primitive ? "FMT_PrimitiveType" : "FMT_DeclaredType"), (Object)this.propertyType);
    }

    @Override
    protected ImageIcon getIcon() {
        if (this.system) {
            if (SYSTEM_ICON == null) {
                SYSTEM_ICON = ImageUtilities.loadImageIcon((String)SYSTEM_ICON_RESOURCE, (boolean)false);
            }
            return SYSTEM_ICON;
        }
        if (this.map) {
            if (MAP_ICON == null) {
                MAP_ICON = ImageUtilities.loadImageIcon((String)MAP_ICON_RESOURCE, (boolean)false);
            }
            return MAP_ICON;
        }
        if (ICON == null) {
            ICON = ImageUtilities.loadImageIcon((String)ICON_RESOURCE, (boolean)false);
        }
        return ICON;
    }

    public String toString() {
        return "property[" + super.getSubstituteText() + "]";
    }
}

