/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.util.WeakListeners;

public class CssPreferences {
    public static final String FIND_IN_UNRELATED_FILES = "cssFindInUnrelatedFiles";
    public static final boolean FIND_IN_UNRELATED_FILES_DEFAULT = true;
    private static boolean findInUnrelatedFiles;
    private static String disabledErrorChecks;
    private static final String disabledErrorChecks_key = "disabledErrorChecks";
    private static String disabledErrorChecks_default;
    private static final char DELIMITER_CHAR = ';';
    private static final String DELIMITER = ";";
    private static final String ENCODED_DELIMITER = "\\;";
    private static final Pattern DELIMITER_PATTERN;
    private static final Pattern ENCODED_DELIMITER_PATTEN;
    private static final AtomicBoolean initialized;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;

    private static void lazyIntialize() {
        if (initialized.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/css").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private CssPreferences() {
    }

    public static boolean findInUnrelatedFiles() {
        CssPreferences.lazyIntialize();
        return findInUnrelatedFiles;
    }

    public static void setFindInUnrelatedFiles(boolean value) {
        CssPreferences.lazyIntialize();
        preferences.putBoolean(FIND_IN_UNRELATED_FILES, value);
    }

    public static Collection<String> getDisabledErrorChecks() {
        CssPreferences.lazyIntialize();
        return CssPreferences.getDisabledErrorChecksAsCollection();
    }

    public static boolean isErrorCheckingDisabledForCssErrorKey(String errorKey) {
        return CssPreferences.getDisabledErrorChecks().contains(CssPreferences.encodeKey(errorKey));
    }

    public static void setCssErrorChecking(String errorKey, boolean enabled) {
        CssPreferences.lazyIntialize();
        errorKey = CssPreferences.encodeKey(errorKey);
        Collection<String> mimescol = CssPreferences.getDisabledErrorChecksAsCollection();
        if (mimescol.contains(errorKey)) {
            if (!enabled) {
                return;
            }
            mimescol.remove(errorKey);
        } else if (!enabled) {
            mimescol.add(errorKey);
        } else {
            return;
        }
        preferences.put(disabledErrorChecks_key, CssPreferences.encodeKeys(mimescol));
    }

    private static String encodeKeys(Collection<String> mimes) {
        StringBuilder b = new StringBuilder();
        for (String m : mimes) {
            b.append(m);
            b.append(';');
        }
        return b.toString();
    }

    private static Collection<String> getDisabledErrorChecksAsCollection() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(disabledErrorChecks.split(DELIMITER)));
        return list;
    }

    private static String encodeKey(String key) {
        return DELIMITER_PATTERN.matcher(key).replaceAll(ENCODED_DELIMITER);
    }

    private static String decodeKey(String key) {
        return ENCODED_DELIMITER_PATTEN.matcher(key).replaceAll(DELIMITER);
    }

    static {
        disabledErrorChecks_default = "";
        DELIMITER_PATTERN = Pattern.compile(DELIMITER);
        ENCODED_DELIMITER_PATTEN = Pattern.compile(ENCODED_DELIMITER);
        initialized = new AtomicBoolean(false);
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || CssPreferences.FIND_IN_UNRELATED_FILES.equals(settingName)) {
                    findInUnrelatedFiles = preferences.getBoolean(CssPreferences.FIND_IN_UNRELATED_FILES, true);
                }
                if (settingName == null || CssPreferences.disabledErrorChecks_key.equals(settingName)) {
                    disabledErrorChecks = preferences.get(CssPreferences.disabledErrorChecks_key, disabledErrorChecks_default);
                }
            }
        };
    }
}

