/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Utilities;

final class AutoHidingMenuBar {
    private final JFrame frame;
    private final int UNHIDE_MENU_BY_MOUSE_DELAY_MS = 400;
    private final Timer delayedAppearanceTimer = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoHidingMenuBar.this.setMenuBarVisible(true);
        }
    });
    private JMenuBar menuBar;
    private boolean autoHideEnabled;
    private InputMap menuOpenKeyboardShortcuts = new InputMap();

    public AutoHidingMenuBar(JFrame frame) {
        if (frame == null) {
            throw new NullPointerException();
        }
        this.frame = frame;
        this.delayedAppearanceTimer.setRepeats(false);
    }

    public void setAutoHideEnabled(boolean autoHideEnabled) {
        if (this.autoHideEnabled == autoHideEnabled) {
            return;
        }
        if (autoHideEnabled && Utilities.isMac()) {
            throw new UnsupportedOperationException("AutoHidingMenuBar not needed on MacOS");
        }
        this.delayedAppearanceTimer.stop();
        if (autoHideEnabled) {
            this.menuBar = this.frame.getJMenuBar();
            if (this.menuBar == null) {
                return;
            }
        }
        this.autoHideEnabled = autoHideEnabled;
        AWTEventListener awtEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent evt) {
                KeyEvent keyEvent;
                KeyStroke keyStroke;
                if (evt instanceof MouseEvent) {
                    AutoHidingMenuBar.this.updateMenuBarVisibility((MouseEvent)evt);
                } else if (evt instanceof KeyEvent && !AutoHidingMenuBar.this.menuBar.isVisible() && (keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent = (KeyEvent)evt)) != null && AutoHidingMenuBar.this.menuOpenKeyboardShortcuts.get(keyStroke) != null) {
                    AutoHidingMenuBar.this.setMenuBarVisible(true);
                    AutoHidingMenuBar.this.frame.validate();
                    MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
                }
            }
        };
        ChangeListener menuSelectionListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AutoHidingMenuBar.this.updateMenuBarVisibility(null);
            }
        };
        if (autoHideEnabled) {
            Toolkit.getDefaultToolkit().addAWTEventListener(awtEventListener, 40L);
            MenuSelectionManager.defaultManager().addChangeListener(menuSelectionListener);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(awtEventListener);
            MenuSelectionManager.defaultManager().removeChangeListener(menuSelectionListener);
        }
        this.updateMenuBarVisibility(null);
    }

    private void populateMenuOpenKeyboardShortcuts(JComponent component) {
        KeyStroke[] keyStrokes;
        InputMap im = component.getInputMap(2);
        if (im != null && (keyStrokes = im.allKeys()) != null) {
            KeyStroke[] keyStrokeArray = keyStrokes;
            int n = keyStrokeArray.length;
            for (int i = 0; i < n; ++i) {
                KeyStroke keyStroke = keyStrokeArray[i];
                this.menuOpenKeyboardShortcuts.put(keyStroke, "OpenMenu");
            }
        }
        if (!(component instanceof JMenu)) {
            for (Component childComponent : component.getComponents()) {
                if (!(childComponent instanceof JComponent)) continue;
                this.populateMenuOpenKeyboardShortcuts((JComponent)childComponent);
            }
        }
    }

    private void setMenuBarVisible(boolean visible) {
        this.delayedAppearanceTimer.stop();
        if (this.menuBar == null) {
            return;
        }
        if (visible == this.menuBar.isVisible()) {
            return;
        }
        if (!visible) {
            if (this.isMenuItemSelected()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            this.menuOpenKeyboardShortcuts = new InputMap();
            this.populateMenuOpenKeyboardShortcuts(this.menuBar);
        }
        this.menuBar.setVisible(visible);
        this.menuBar.revalidate();
    }

    private void updateMenuBarVisibility(MouseEvent evt) {
        Component source;
        Point locationOnFrame;
        if (!this.autoHideEnabled) {
            this.setMenuBarVisible(true);
            return;
        }
        if (evt == null && this.isMenuItemSelected()) {
            this.setMenuBarVisible(true);
            return;
        }
        if (evt == null || !(evt.getSource() instanceof Component)) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            Point p = pointerInfo.getLocation();
            if (p == null) {
                return;
            }
            SwingUtilities.convertPointFromScreen(p, this.frame);
            locationOnFrame = p;
            source = this.frame.findComponentAt(locationOnFrame.x, locationOnFrame.y);
        } else {
            source = (Component)evt.getSource();
            Point p = evt.getPoint();
            SwingUtilities.convertPointToScreen(p, source);
            SwingUtilities.convertPointFromScreen(p, this.frame);
            locationOnFrame = p;
        }
        if (locationOnFrame.y == 0 && !this.menuBar.isVisible()) {
            this.delayedAppearanceTimer.start();
        } else if (!(!this.menuBar.isVisible() && !this.delayedAppearanceTimer.isRunning() || locationOnFrame.y <= this.menuBar.getHeight() || this.isComponentInMenu(source) || this.isComponentInMenu(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) || this.isMenuItemSelected())) {
            this.setMenuBarVisible(false);
        }
    }

    private boolean isMenuItemSelected() {
        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
        return selectedPath != null && selectedPath.length > 0 && selectedPath[0] == this.menuBar;
    }

    private boolean isComponentInMenu(Component comp) {
        if (comp == null) {
            return false;
        }
        if (comp == this.menuBar) {
            return true;
        }
        return this.isComponentInMenu(comp.getParent());
    }
}

