/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.Point;
import java.awt.image.BufferedImage;
import org.netbeans.jemmy.image.ImageFinder;

public class RoughImageFinder
implements ImageFinder {
    double roughness = 0.0;
    int bigWidth;
    int bigHeight;
    int[][] bigPixels;

    public RoughImageFinder(BufferedImage area, double roughness) {
        this.roughness = roughness;
        this.bigWidth = area.getWidth();
        this.bigHeight = area.getHeight();
        this.bigPixels = new int[this.bigWidth][this.bigHeight];
        for (int x = 0; x < this.bigWidth; ++x) {
            for (int y = 0; y < this.bigHeight; ++y) {
                this.bigPixels[x][y] = area.getRGB(x, y);
            }
        }
    }

    @Override
    public Point findImage(BufferedImage image, int index) {
        int smallWidth = image.getWidth();
        int smallHeight = image.getHeight();
        int[][] smallPixels = new int[smallWidth][smallHeight];
        for (int x = 0; x < smallWidth; ++x) {
            for (int y = 0; y < smallHeight; ++y) {
                smallPixels[x][y] = image.getRGB(x, y);
            }
        }
        double maxRoughPixels = (double)(smallWidth * smallHeight) * this.roughness;
        int count = 0;
        for (int X = 0; X <= this.bigWidth - smallWidth; ++X) {
            for (int Y = 0; Y <= this.bigHeight - smallHeight; ++Y) {
                int roughPixels = 0;
                for (int x = 0; x < smallWidth; ++x) {
                    for (int y = 0; !(y >= smallHeight || smallPixels[x][y] != this.bigPixels[X + x][Y + y] && (double)(++roughPixels) > maxRoughPixels); ++y) {
                    }
                    if ((double)roughPixels > maxRoughPixels) break;
                }
                if (!((double)roughPixels <= maxRoughPixels)) continue;
                if (count == index) {
                    return new Point(X, Y);
                }
                ++count;
            }
        }
        return null;
    }
}

