/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobListener;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.CancelableProgressMonitor;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.internal.Accessor;
import org.netbeans.modules.team.commons.LogUtils;

public class SubmitTaskCommand
extends BugtrackingCommand {
    private final CancelableProgressMonitor monitor;
    private RepositoryResponse rr;
    private NbTask submittedTask;
    private final Set<TaskAttribute> changedOldAttributes;
    private final TaskData taskData;
    private final ITask task;
    private final TaskRepository taskRepository;
    private final AbstractRepositoryConnector repositoryConnector;
    private final TaskDataManager taskDataManager;
    private String stringValue;
    private SubmitJobListener submitJobListener;

    SubmitTaskCommand(TaskDataManager taskDataManager, AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, ITask task, TaskData taskData, Set<TaskAttribute> changedOldAttributes) {
        this.taskDataManager = taskDataManager;
        this.repositoryConnector = repositoryConnector;
        this.taskRepository = taskRepository;
        this.task = task;
        this.taskData = taskData;
        this.changedOldAttributes = changedOldAttributes;
        this.monitor = new CancelableProgressMonitor();
    }

    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        Logger log;
        LogUtils.logBugtrackingUsage((String)this.repositoryConnector.getConnectorKind(), (String)"ISSUE_EDIT");
        MylynSubmitTaskJob job = new MylynSubmitTaskJob(this.taskDataManager, this.repositoryConnector, this.taskRepository, this.task, this.taskData, this.changedOldAttributes);
        if (this.submitJobListener != null) {
            job.addSubmitJobListener(this.submitJobListener);
        }
        if ((log = Logger.getLogger(this.getClass().getName())).isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing SubmitJobCommand for task with id {0}:{1} ", new Object[]{this.task.getTaskId(), this.taskRepository.getUrl()});
        }
        job.startJob(this.monitor);
        IStatus status = job.getStatus();
        this.rr = job.getResponse();
        this.submittedTask = Accessor.getInstance().toNbTask(job.getTask());
        if (status != null && status != Status.OK_STATUS) {
            log.log(Level.INFO, "Command failed with status: {0}", status);
            if (status.getException() instanceof CoreException) {
                throw (CoreException)status.getException();
            }
            throw new CoreException(status);
        }
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            if (this.task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
                sb.append("SubmitTaskCommand new issue [repository=");
                sb.append(this.taskRepository.getUrl());
                sb.append("]");
            } else {
                sb.append("SubmitTaskCommand [task #");
                sb.append(this.taskData.getTaskId());
                sb.append(",repository=");
                sb.append(this.taskRepository.getUrl());
                sb.append("]");
            }
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    @Override
    public void cancel() {
        this.monitor.setCanceled(true);
    }

    public NbTask getSubmittedTask() {
        return this.submittedTask;
    }

    public RepositoryResponse getRepositoryResponse() {
        return this.rr;
    }

    void setSubmitJobListener(SubmitJobListener submitJobListener) {
        this.submitJobListener = submitJobListener;
    }

    private static class MylynSubmitTaskJob
    extends SubmitTaskJob {
        public MylynSubmitTaskJob(TaskDataManager taskDataManager, AbstractRepositoryConnector connector, TaskRepository taskRepository, ITask task, TaskData taskData, Set<TaskAttribute> oldAttributes) {
            super(taskDataManager, connector, taskRepository, task, taskData, oldAttributes);
        }

        public IStatus startJob(IProgressMonitor jobMonitor) {
            return this.run(jobMonitor);
        }
    }
}

