/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class LocalRepositoryConfig {
    private static LocalRepositoryConfig instance;
    private static final String PREF_SECTION_COLLAPSED = "collapsedSection";
    private static final String PREF_TASK = "task.";

    public static synchronized LocalRepositoryConfig getInstance() {
        if (instance == null) {
            instance = new LocalRepositoryConfig();
        }
        return instance;
    }

    private LocalRepositoryConfig() {
    }

    public void setEditorSectionCollapsed(String taskId, String sectionName, boolean collapsed) {
        String key = this.getTaskKey(taskId) + PREF_SECTION_COLLAPSED + sectionName;
        this.getPreferences().putBoolean(key, collapsed);
    }

    public void deleteTaskPreferences(String taskId) {
        Preferences prefs = this.getPreferences();
        try {
            String taskKey = this.getTaskKey(taskId);
            for (String key : prefs.keys()) {
                if (!key.startsWith(taskKey)) continue;
                prefs.remove(key);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public boolean isEditorSectionCollapsed(String taskId, String sectionName, boolean defaultValue) {
        String key = this.getTaskKey(taskId) + PREF_SECTION_COLLAPSED + sectionName;
        return this.getPreferences().getBoolean(key, defaultValue);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(LocalRepositoryConfig.class);
    }

    private String getTaskKey(String taskId) {
        return PREF_TASK + taskId + ".";
    }
}

