/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;

public final class ClientSideProjectDetector {
    private final Detector detector;

    public ClientSideProjectDetector(File siteRoot) {
        this.detector = this.findDetector(siteRoot);
    }

    public boolean detected() {
        return this.detector != Detector.NULL_DETECTOR;
    }

    @CheckForNull
    public String getName() {
        return this.detector.getName();
    }

    @CheckForNull
    public String getProjectDirPath() {
        return this.detector.getProjectDirPath();
    }

    @CheckForNull
    public String getTestDirPath() {
        return this.detector.getTestDirPath();
    }

    private Detector findDetector(File siteRoot) {
        if (siteRoot.isDirectory()) {
            for (Detector det : this.createDetectors(siteRoot)) {
                if (!det.detected(siteRoot)) continue;
                return det;
            }
        }
        return Detector.NULL_DETECTOR;
    }

    private List<Detector> createDetectors(File siteRoot) {
        return Arrays.asList(new AngularJsDetector(siteRoot), new StandardJsProjectDetector(siteRoot));
    }

    private static final class AngularJsDetector
    implements Detector {
        private static final String NAME = "AngularJsApplication";
        private static final String SITE_ROOT = "app";
        private static final String TEST_ROOT = "test";
        private final File siteRoot;

        private AngularJsDetector(File siteRoot) {
            this.siteRoot = siteRoot;
        }

        @Override
        public boolean detected(File siteRoot) {
            if (siteRoot != this.siteRoot) {
                throw new IllegalArgumentException("Unexpected site root given (" + siteRoot + "), expected " + this.siteRoot);
            }
            if (!SITE_ROOT.equals(siteRoot.getName())) {
                return false;
            }
            return this.getTestDir().isDirectory();
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String getProjectDirPath() {
            return this.getProjectDir().getAbsolutePath();
        }

        @Override
        public String getTestDirPath() {
            return this.getTestDir().getAbsolutePath();
        }

        private File getProjectDir() {
            return this.siteRoot.getParentFile();
        }

        private File getTestDir() {
            return new File(this.getProjectDir(), TEST_ROOT);
        }
    }

    private static final class StandardJsProjectDetector
    implements Detector {
        private static final Collection<String> WELL_KNOWN_SITE_ROOTS = Arrays.asList("public_html", "public", "web", "www");
        private final File siteRoot;

        public StandardJsProjectDetector(File siteRoot) {
            this.siteRoot = siteRoot;
        }

        @Override
        public boolean detected(File siteRoot) {
            if (siteRoot != this.siteRoot) {
                throw new IllegalArgumentException("Unexpected site root given (" + siteRoot + "), expected " + this.siteRoot);
            }
            return WELL_KNOWN_SITE_ROOTS.contains(siteRoot.getName().toLowerCase());
        }

        @Override
        public String getName() {
            return this.siteRoot.getParentFile().getName();
        }

        @Override
        public String getProjectDirPath() {
            return this.siteRoot.getParentFile().getAbsolutePath();
        }

        @Override
        public String getTestDirPath() {
            return null;
        }
    }

    private static interface Detector {
        public static final Detector NULL_DETECTOR = new Detector(){

            @Override
            public boolean detected(File siteRoot) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getProjectDirPath() {
                return null;
            }

            @Override
            public String getTestDirPath() {
                return null;
            }
        };

        public boolean detected(File var1);

        public String getName();

        public String getProjectDirPath();

        public String getTestDirPath();
    }
}

