/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ReloadAction
extends AbstractAction {
    static final String CATEGORY = "Build";
    static final String ID = "org.netbeans.modules.payara.micro.action.reload";
    private static final RequestProcessor RP = new RequestProcessor(ReloadAction.class.getName());

    @Override
    public void actionPerformed(ActionEvent e) {
        Lookup context = Utilities.actionsGlobalContext();
        Project project = (Project)context.lookup(Project.class);
        if (project == null) {
            return;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        MicroApplication microApplication = MicroApplication.getInstance(project);
        if (microApplication == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ReloadAction.class, (String)"ERR_Payara_Micro_Plugin_Not_Found", (Object)mavenProject.getArtifactId()));
        } else if (!RunUtils.isCompileOnSaveEnabled((Project)microApplication.getProject())) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ReloadAction.class, (String)"ERR_Compile_On_Save_Not_Enabled", (Object)mavenProject.getArtifactId()));
        } else {
            RP.post(() -> {
                String action = RunUtils.isCompileOnSaveEnabled((Project)project) ? "micro-explode" : "micro-complie-explode";
                NetbeansActionMapping mapping = ActionToGoalUtils.getDefaultMapping((String)action, (Project)project);
                ModelRunConfig rc = new ModelRunConfig(project, mapping, mapping.getActionName(), null, Lookup.EMPTY, false);
                rc.setTaskDisplayName(NbBundle.getMessage(ReloadAction.class, (String)"TXT_Reload", (Object)mavenProject.getArtifactId()));
                RunUtils.run((RunConfig)rc);
            });
        }
    }

    public static void reloadApplication(String buildPath) {
        File check = new File(buildPath, ".reload");
        if (check.exists()) {
            check.setLastModified(System.currentTimeMillis());
        } else {
            try {
                check.createNewFile();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

