/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.preferences;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.karma.util.KarmaUtils;
import org.netbeans.modules.javascript.karma.util.StringUtils;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class KarmaPreferences {
    public static final String CONFIG = "config";
    private static final String ENABLED = "enabled";
    private static final String AUTOWATCH = "autowatch";
    private static final String DEBUG = "debug";
    private static final String DEBUG_BROWSER_ID = "debug.browser.id";
    private static final String BROWSER_ERROR_FAIL = "browser.error.fail";
    private static final ConcurrentMap<Project, Preferences> CACHE = new ConcurrentHashMap<Project, Preferences>();

    private KarmaPreferences() {
    }

    public static boolean isEnabled(Project project) {
        return KarmaPreferences.getPreferences(project).getBoolean(ENABLED, false);
    }

    public static void setEnabled(Project project, boolean enabled) {
        KarmaPreferences.getPreferences(project).putBoolean(ENABLED, enabled);
    }

    @CheckForNull
    public static String getConfig(Project project) {
        return KarmaPreferences.resolvePath(project, KarmaPreferences.getPreferences(project).get(CONFIG, null));
    }

    public static void setConfig(Project project, String config) {
        KarmaPreferences.getPreferences(project).put(CONFIG, KarmaPreferences.relativizePath(project, config));
    }

    public static boolean isAutowatch(Project project) {
        return KarmaPreferences.getPreferences(project).getBoolean(AUTOWATCH, false);
    }

    public static void setAutowatch(Project project, boolean autowatch) {
        KarmaPreferences.getPreferences(project).putBoolean(AUTOWATCH, autowatch);
    }

    public static boolean isDebug(Project project) {
        return KarmaPreferences.getPreferences(project).getBoolean(DEBUG, false);
    }

    public static void setDebug(Project project, boolean debug) {
        KarmaPreferences.getPreferences(project).putBoolean(DEBUG, debug);
    }

    public static boolean isDebugBrowserIdSet(Project project) {
        return KarmaPreferences.getPreferences(project).get(DEBUG_BROWSER_ID, null) != null;
    }

    @CheckForNull
    public static String getDebugBrowserId(Project project) {
        String browserId = KarmaPreferences.getPreferences(project).get(DEBUG_BROWSER_ID, null);
        if (browserId != null) {
            return browserId;
        }
        WebBrowser preferredBrowser = KarmaUtils.getPreferredDebugBrowser();
        if (preferredBrowser != null) {
            return preferredBrowser.getId();
        }
        return null;
    }

    public static void setDebugBrowserId(Project project, String browserId) {
        KarmaPreferences.getPreferences(project).put(DEBUG_BROWSER_ID, browserId);
    }

    public static boolean isFailOnBrowserError(Project project) {
        return KarmaPreferences.getPreferences(project).getBoolean(BROWSER_ERROR_FAIL, true);
    }

    public static void setFailOnBrowserError(Project project, boolean fail) {
        KarmaPreferences.getPreferences(project).putBoolean(BROWSER_ERROR_FAIL, fail);
    }

    public static void addPreferenceChangeListener(Project project, PreferenceChangeListener listener) {
        KarmaPreferences.getPreferences(project).addPreferenceChangeListener(listener);
    }

    public static void removePreferenceChangeListener(Project project, PreferenceChangeListener listener) {
        KarmaPreferences.getPreferences(project).removePreferenceChangeListener(listener);
    }

    public static void removeFromCache(Project project) {
        CACHE.remove(project);
    }

    private static Preferences getPreferences(Project project) {
        assert (project != null);
        Preferences preferences = (Preferences)CACHE.get(project);
        if (preferences == null) {
            preferences = ProjectUtils.getPreferences((Project)project, KarmaPreferences.class, (boolean)false);
            Preferences currentPreferences = CACHE.putIfAbsent(project, preferences);
            if (currentPreferences != null) {
                preferences = currentPreferences;
            } else {
                KarmaPreferences.detectConfig(project);
            }
        }
        assert (preferences != null);
        return preferences;
    }

    private static void detectConfig(Project project) {
        if (KarmaPreferences.getConfig(project) != null) {
            return;
        }
        File config = KarmaUtils.findKarmaConfig(KarmaUtils.getKarmaConfigDir(project));
        if (config != null) {
            KarmaPreferences.setConfig(project, config.getAbsolutePath());
        }
    }

    private static String relativizePath(Project project, String filePath) {
        if (!StringUtils.hasText(filePath)) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (File)file);
        if (path == null || path.startsWith("../")) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(Project project, String filePath) {
        if (!StringUtils.hasText(filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

