/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.java.support.LibrariesHelper;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.ui.CodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SoapClientPojoCodeGenerator
extends SaasClientCodeGenerator {
    public static final String QNAME = "javax.xml.namespace.QName";
    public static final String WS_BINDING_PROVIDER = "com.sun.xml.ws.developer.WSBindingProvider";
    public static final String HEADERS = "com.sun.xml.ws.api.message.Headers";
    public static final String SET_HEADER_PARAMS = "setHeaderParameters";
    public static final String VAR_NAMES_SERVICE = "service";
    public static final String VAR_NAMES_PORT = "port";
    public static final String HINT_INIT_ARGUMENTS = " // TODO initialize WS operation arguments here\n";
    private static final String JAVA_SERVICE_DEF = "   {0} {7} = new {0}();\n";
    private static final String JAVA_PORT_DEF = "   {1} {11} = {7}.{2}();\n";
    private static final String JAVA_RESULT = "   {3}   // TODO process result here\n   {4} {9} = {11}.{5}({6});\n";
    private static final String JAVA_VOID = "   {3}   {11}.{5}({6});\n";
    private static final String JAVA_OUT = "   {8}.println(\"Result = \"+{9});\n";
    private static final String JAVA_STATIC_STUB_ASYNC_POLLING = "\ntry '{' // Call Web Service Operation(async. polling)\n   {0} {10} = new {0}();\n   {1} {11} = {10}.{2}();\n   {3}   // TODO process asynchronous response here\n   {4} {9} = {11}.{5}({6});\n   while(!{9}.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n   System.out.println(\"Result = \"+{9}.get());\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String JAVA_STATIC_STUB_ASYNC_CALLBACK = "\ntry '{' // Call Web Service Operation(async. callback)\n   {0} {10} = new {0}();\n   {1} {11} = {10}.{2}();\n   {3}       public void handleResponse(javax.xml.ws.Response<{7}> {9}Resp) '{'\n           try '{'\n               // TODO process asynchronous response here\n               System.out.println(\"Result = \"+ {9}Resp.get());\n           '}' catch(Exception ex) '{'\n               // TODO handle exception\n           '}'\n       '}'\n   '}';\n   {4} {9} = {11}.{5}({6});\n   while(!{9}.isDone()) '{'\n       // do something\n       Thread.sleep(100);\n   '}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    private static final String INVOKE_JAXRPC_BODY = "\t\t{0} {1} = new {0}_Impl();\n\t\t{2} {3} = {1}.{4}();\n\t\t{8} {3}.{5}({6});\n";
    public static final String SET_HEADER_PARAMS_CALL = "setHeaderParameters(port); \n";

    public SoapClientPojoCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
    }

    public boolean canAccept(SaasMethod method, Document doc) {
        if (SaasBean.canAccept((SaasMethod)method, WsdlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && Util.isJava((Document)doc)) {
            try {
                WsdlSaasMethod wsm = (WsdlSaasMethod)method;
                Project p = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)doc));
                new SoapClientSaasBean(wsm, p, (SoapClientOperationInfo[])JavaUtil.toJaxwsOperationInfos(wsm, p));
                return true;
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, null, NbBundle.getMessage(CodeSetupPanel.class, (String)"WARN_UnsupportedDropTarget"));
            }
        }
        return false;
    }

    public void init(SaasMethod m, Document doc) throws IOException {
        super.init(m, doc);
        WsdlSaasMethod wsm = (WsdlSaasMethod)m;
        Project p = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)doc));
        SoapClientSaasBean bean = new SoapClientSaasBean(wsm, p, (SoapClientOperationInfo[])JavaUtil.toJaxwsOperationInfos(wsm, p));
        this.setBean((SaasBean)bean);
        this.clearVariablePatterns();
    }

    public SoapClientSaasBean getBean() {
        return (SoapClientSaasBean)super.getBean();
    }

    protected void preGenerate() throws IOException {
        SoapClientOperationInfo[] operations;
        super.preGenerate();
        for (SoapClientOperationInfo info : operations = this.getBean().getOperationInfos()) {
            if (info.isRPCEncoded()) {
                LibrariesHelper.addDefaultJaxRpcClientJars(this.getProject(), null, info.getMethod().getSaas());
                continue;
            }
            LibrariesHelper.addDefaultJaxWsClientJars(this.getProject(), null, info.getMethod().getSaas());
        }
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.emptyList());
    }

    protected void insertSaasServiceAccessCode(boolean isInBlock) throws IOException {
        try {
            String code = "";
            if (isInBlock) {
                code = this.getCustomMethodBody();
            } else {
                code = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                code = code + this.getCustomMethodBody() + "\n";
                code = code + "return " + this.getResultPattern() + ";\n";
                code = code + "}\n";
            }
            this.insert(code, true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected String getCustomMethodBody() throws IOException {
        SoapClientOperationInfo[] operations;
        String methodBody = "\n        try {\n";
        List params = this.getBean().getQueryParameters();
        this.updateVariableNames(params);
        List renamedParams = this.renameParameterNames(params);
        for (ParameterInfo param : renamedParams) {
            String name = param.getName();
            methodBody = methodBody + "             " + param.getType().getName() + " " + name + " = " + SoapClientPojoCodeGenerator.resolveInitValue(param) + "\n";
        }
        for (SoapClientOperationInfo info : operations = this.getBean().getOperationInfos()) {
            methodBody = !info.isRPCEncoded() ? methodBody + this.getWSInvocationCode(info) : methodBody + this.getWSInvocationCodeForJaxrpc(info);
        }
        methodBody = methodBody + "        } catch (Exception ex) {\n";
        methodBody = methodBody + "             ex.printStackTrace();\n";
        methodBody = methodBody + "        }\n";
        return methodBody;
    }

    private static String varFromName(String name) {
        if (name.length() > 0) {
            StringBuffer buf = new StringBuffer(name);
            if (Character.isUpperCase(buf.charAt(0))) {
                buf.setCharAt(0, Character.toLowerCase(buf.charAt(0)));
            } else {
                buf.insert(0, '_');
            }
            return SoapClientPojoCodeGenerator.removeDots(buf).toString();
        }
        return "unknown";
    }

    private static StringBuffer removeDots(StringBuffer name) {
        int dotIndex;
        while ((dotIndex = name.indexOf(".")) > -1) {
            name.deleteCharAt(dotIndex);
            name.setCharAt(dotIndex, Character.toUpperCase(name.charAt(dotIndex)));
        }
        return name;
    }

    private String getWSInvocationCodeForJaxrpc(SoapClientOperationInfo info) throws IOException {
        String serviceClassName = info.getService().getJavaName();
        String serviceLookup = serviceClassName.substring(serviceClassName.lastIndexOf(".") + 1);
        String serviceName = info.getServiceName();
        if (serviceName == null || serviceName.length() == 0) {
            serviceName = VAR_NAMES_SERVICE;
        }
        String serviceVarName = SoapClientPojoCodeGenerator.varFromName(serviceName);
        String servicePortClassName = info.getPort().getJavaName();
        String portVarName = SoapClientPojoCodeGenerator.varFromName(info.getPortName());
        String portGetterName = info.getPort().getPortGetter();
        String serviceOperationName = info.getOperation().getJavaMethod().getName();
        List outArguments = info.getOutputParameters();
        this.updateVariableNamesForWS(outArguments);
        String responseType = "Object";
        String argumentInitializationPart = "";
        String argumentDeclarationPart = "";
        String resultStatement = "";
        String resultTypeName = "";
        String resultVariable = "";
        StringBuffer argumentBuffer2 = new StringBuffer("");
        try {
            StringBuffer argumentBuffer1 = new StringBuffer();
            for (int i = 0; i < outArguments.size(); ++i) {
                String argumentTypeName = ((WSParameter)outArguments.get(i)).getTypeName();
                String argumentName = this.findNewName(this.getVariableDecl((WSParameter)outArguments.get(i)), ((WSParameter)outArguments.get(i)).getName());
                argumentBuffer1.append("             " + argumentTypeName + " " + argumentName + " = " + SoapClientPojoCodeGenerator.resolveInitValue(argumentTypeName) + "\n");
            }
            List parameters = info.getOperation().getParameters();
            this.updateVariableNamesForWS(parameters);
            for (int i = 0; i < parameters.size(); ++i) {
                String argument = this.findNewName(this.getVariableDecl((WSParameter)parameters.get(i)), ((WSParameter)parameters.get(i)).getName());
                argumentBuffer2.append(i > 0 ? ", " + argument : argument);
            }
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            resultTypeName = info.getOperation().getReturnTypeName();
            resultVariable = "result";
            argumentDeclarationPart = argumentBuffer2.toString();
            if (!resultTypeName.equals("void")) {
                resultStatement = resultTypeName + " " + resultVariable + " =";
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        Object[] args = new String[]{serviceClassName, serviceVarName, servicePortClassName, portVarName, portGetterName, serviceOperationName, argumentDeclarationPart, serviceLookup, resultStatement};
        String operationInvocation = MessageFormat.format(INVOKE_JAXRPC_BODY, args);
        return operationInvocation;
    }

    protected String getWSInvocationCode(SoapClientOperationInfo info) throws IOException {
        String serviceJavaName = info.getService().getJavaName();
        String portJavaName = info.getPort().getJavaName();
        String operationJavaName = info.getOperation().getJavaName();
        String portGetterMethod = info.getPort().getPortGetter();
        String pkgName = ((WsdlSaas)this.getBean().getSaas()).getWsdlData().getJaxWsDescriptor().getPackageName();
        if (pkgName != null) {
            if (serviceJavaName.lastIndexOf(".") != -1) {
                serviceJavaName = serviceJavaName.substring(serviceJavaName.lastIndexOf(".") + 1);
            }
            serviceJavaName = pkgName + "." + serviceJavaName;
            if (portJavaName.lastIndexOf(".") != -1) {
                portJavaName = portJavaName.substring(portJavaName.lastIndexOf(".") + 1);
            }
            portJavaName = pkgName + "." + portJavaName;
        }
        String serviceFieldName = this.findNewName(serviceJavaName + " " + VAR_NAMES_SERVICE, VAR_NAMES_SERVICE);
        String returnTypeName = info.getOperation().getReturnTypeName();
        List outArguments = info.getOutputParameters();
        this.updateVariableNamesForWS(outArguments);
        String responseType = "Object";
        String callbackHandlerName = "javax.xml.ws.AsyncHandler";
        String argumentInitializationPart = "";
        String argumentDeclarationPart = "";
        try {
            StringBuffer argumentBuffer1 = new StringBuffer();
            StringBuffer argumentBuffer2 = new StringBuffer();
            for (int i = 0; i < outArguments.size(); ++i) {
                String argumentTypeName = ((WSParameter)outArguments.get(i)).getTypeName();
                if (argumentTypeName.startsWith("javax.xml.ws.AsyncHandler")) {
                    responseType = SoapClientPojoCodeGenerator.resolveResponseType(argumentTypeName);
                    callbackHandlerName = argumentTypeName;
                }
                String argumentName = this.findNewName(this.getVariableDecl((WSParameter)outArguments.get(i)), ((WSParameter)outArguments.get(i)).getName());
                argumentBuffer1.append("             " + argumentTypeName + " " + argumentName + " = " + SoapClientPojoCodeGenerator.resolveInitValue(argumentTypeName) + "\n");
            }
            List parameters = info.getOperation().getParameters();
            this.updateVariableNamesForWS(parameters);
            for (int i = 0; i < parameters.size(); ++i) {
                String argument = this.findNewName(this.getVariableDecl((WSParameter)parameters.get(i)), ((WSParameter)parameters.get(i)).getName());
                argumentBuffer2.append(i > 0 ? ", " + argument : argument);
            }
            argumentInitializationPart = argumentBuffer1.length() > 0 ? "\t // TODO initialize WS operation arguments here\n" + argumentBuffer1.toString() : "";
            argumentDeclarationPart = argumentBuffer2.toString();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            String message = NbBundle.getMessage(SoapClientPojoCodeGenerator.class, (String)"ERR_FailedUnexpectedWebServiceDescriptionPattern");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
        final boolean[] insertServiceDef = new boolean[]{true};
        String[] printerName = new String[]{"System.out"};
        String[] argumentInitPart = new String[]{argumentInitializationPart};
        String[] argumentDeclPart = new String[]{argumentDeclarationPart};
        final String[] serviceFName = new String[]{serviceFieldName};
        final boolean[] generateWsRefInjection = new boolean[]{false};
        final String serviceJName = serviceJavaName;
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){
            private Tree.Kind VARIABLE;

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                CompilationUnitTree cut = controller.getCompilationUnit();
                ClassTree classTree = JavaSourceHelper.findPublicTopLevelClass(controller);
                generateWsRefInjection[0] = JavaSourceHelper.isInjectionTarget(controller);
                boolean bl = insertServiceDef[0] = !generateWsRefInjection[0];
                if (generateWsRefInjection[0]) {
                    HashSet<String> serviceFieldNames = new HashSet<String>();
                    boolean injectionExists = false;
                    int memberOrder = 0;
                    for (Tree tree : classTree.getMembers()) {
                        String variableType;
                        ++memberOrder;
                        if (this.VARIABLE != tree.getKind()) continue;
                        VariableTree var = (VariableTree)tree;
                        Tree typeTree = var.getType();
                        TreePath typeTreePath = controller.getTrees().getPath(cut, typeTree);
                        TypeElement typeEl = JavaSourceHelper.getTypeElement(controller, typeTreePath);
                        if (typeEl != null && serviceJName.equals(variableType = typeEl.getQualifiedName().toString())) {
                            serviceFName[0] = var.getName().toString();
                            generateWsRefInjection[0] = false;
                            injectionExists = true;
                            break;
                        }
                        serviceFieldNames.add(var.getName().toString());
                    }
                    if (!injectionExists) {
                        serviceFName[0] = SoapClientPojoCodeGenerator.findProperServiceFieldName(serviceFieldNames);
                    }
                }
            }

            public void cancel() {
            }
        };
        String invocationBody = this.getJavaInvocationBody(info.getOperation(), insertServiceDef[0], serviceJavaName, portJavaName, portGetterMethod, argumentInitPart[0], returnTypeName, operationJavaName, argumentDeclPart[0], serviceFName[0], printerName[0], responseType);
        return invocationBody;
    }

    protected static String resolveInitValue(String type) {
        if (type.startsWith("javax.xml.ws.Holder")) {
            return "new " + type + "();";
        }
        if ("int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type)) {
            return "0;";
        }
        if ("boolean".equals(type)) {
            return "false;";
        }
        if ("float".equals(type) || "double".equals(type)) {
            return "0.0;";
        }
        if ("java.lang.String".equals(type)) {
            return "\"\";";
        }
        if (type.endsWith("CallbackHandler")) {
            return "new " + type + "();";
        }
        if (type.startsWith("javax.xml.ws.AsyncHandler")) {
            return "new " + type + "() {";
        }
        return "null;";
    }

    protected static String resolveInitValue(ParameterInfo p) {
        String type = p.getTypeName();
        Object defaultVal = p.getDefaultValue();
        if (type.startsWith("javax.xml.ws.Holder")) {
            return "new " + type + "();";
        }
        if ("int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Long".equals(type) || "java.lang.Short".equals(type) || "java.lang.Byte".equals(type)) {
            try {
                int val = Integer.parseInt((String)defaultVal);
                return String.valueOf(val) + ";";
            }
            catch (Exception val) {
                return "0;";
            }
        }
        if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            return defaultVal.toString() + ";";
        }
        if ("float".equals(type) || "double".equals(type) || "java.lang.Float".equals(type) || "java.lang.Double".equals(type)) {
            try {
                double val = Double.parseDouble((String)defaultVal);
                return String.valueOf(val) + ";";
            }
            catch (Exception exception) {
                return "0.0;";
            }
        }
        if ("java.lang.String".equals(type)) {
            if (defaultVal != null && defaultVal instanceof String) {
                return "\"" + (String)defaultVal + "\";";
            }
            return "\"\";";
        }
        if (type.endsWith("CallbackHandler")) {
            return "new " + type + "();";
        }
        if (type.startsWith("javax.xml.ws.AsyncHandler")) {
            return "new " + type + "() {";
        }
        return "null;";
    }

    protected static String resolveResponseType(String argumentType) {
        int start = argumentType.indexOf("<");
        int end = argumentType.indexOf(">");
        if (start > 0 && end > 0 && start < end) {
            return argumentType.substring(start + 1, end);
        }
        return "javax.xml.ws.Response";
    }

    protected String getJavaInvocationBody(WSOperation operation, boolean insertServiceDef, String serviceJavaName, String portJavaName, String portGetterMethod, String argumentInitializationPart, String returnTypeName, String operationJavaName, String argumentDeclarationPart, String serviceFieldName, String printerName, String responseType) {
        String invocationBody = "             ";
        String setHeaderParams = this.getBean().getHeaderParameters().size() > 0 ? SET_HEADER_PARAMS_CALL : "";
        Object[] args = new Object[]{serviceJavaName, portJavaName, portGetterMethod, argumentInitializationPart, returnTypeName, operationJavaName, argumentDeclarationPart, serviceFieldName, printerName, this.getResultPattern(), this.findNewName(serviceJavaName + " " + VAR_NAMES_SERVICE, VAR_NAMES_SERVICE), this.findNewName(portJavaName + " " + VAR_NAMES_PORT, VAR_NAMES_PORT)};
        switch (operation.getOperationType()) {
            case 0: {
                if ("void".equals(returnTypeName)) {
                    String body = (insertServiceDef ? JAVA_SERVICE_DEF : "") + setHeaderParams + JAVA_PORT_DEF + JAVA_VOID;
                    invocationBody = invocationBody + MessageFormat.format(body, args);
                    break;
                }
                String body = (insertServiceDef ? JAVA_SERVICE_DEF : "") + JAVA_PORT_DEF + setHeaderParams + JAVA_RESULT + JAVA_OUT;
                invocationBody = invocationBody + MessageFormat.format(body, args);
                break;
            }
            case 1: {
                invocationBody = invocationBody + MessageFormat.format(JAVA_STATIC_STUB_ASYNC_POLLING, args);
                break;
            }
            case 2: {
                args[7] = responseType;
                invocationBody = invocationBody + MessageFormat.format(JAVA_STATIC_STUB_ASYNC_CALLBACK, args);
            }
        }
        return invocationBody;
    }

    protected static String findProperServiceFieldName(Set serviceFieldNames) {
        String name = VAR_NAMES_SERVICE;
        int i = 0;
        while (serviceFieldNames.contains(name)) {
            name = "service_" + String.valueOf(++i);
        }
        return name;
    }

    private ClassTree addSetHeaderParamsMethod(WorkingCopy copy, ClassTree tree, String portJavaType) {
        Modifier[] modifiers = JavaUtil.PRIVATE;
        String[] annotations = new String[]{};
        Object[] annotationAttrs = new Object[]{};
        String returnType = "void";
        String bodyText = "{ WSBindingProvider bp = (WSBindingProvider)port;";
        bodyText = bodyText + "bp.setOutboundHeaders(";
        boolean first = true;
        for (ParameterInfo pinfo : this.getBean().getHeaderParameters()) {
            if (pinfo.getDefaultValue() == null) continue;
            if (first) {
                first = false;
            } else {
                bodyText = bodyText + ", \n ";
            }
            String namespaceUri = pinfo.getQName().getNamespaceURI();
            bodyText = bodyText + "Headers.create(new QName(";
            if (namespaceUri != null) {
                bodyText = bodyText + "\"" + namespaceUri + "\",";
            }
            bodyText = bodyText + "\"" + pinfo.getName() + "\"), \"" + pinfo.getDefaultValue() + "\")";
        }
        bodyText = bodyText + ");";
        String[] parameters = new String[]{this.findNewName(portJavaType + " " + VAR_NAMES_PORT, VAR_NAMES_PORT)};
        Object[] paramTypes = new Object[]{portJavaType};
        Object[] paramAnnotations = new String[]{};
        Object[] paramAnnotationAttrs = new String[]{};
        String comment = null;
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, SET_HEADER_PARAMS, returnType, parameters, paramTypes, paramAnnotations, paramAnnotationAttrs, bodyText, comment);
    }
}

