/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.nodes;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugtracking.bridge.nodes.RepositoryNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class BugtrackingRootNode
extends AbstractNode {
    private static final String BUGTRACKING_NODE_NAME = "bugtracking";
    private static final String ICON_BASE = "org/netbeans/modules/bugtracking/ui/resources/bugtracking.png";
    private static final Object LOCK_INIT = new Object();
    private static BugtrackingRootNode defaultInstance;

    private BugtrackingRootNode() {
        super(Children.create((ChildFactory)new RootNodeChildren(), (boolean)true));
        this.setName(BUGTRACKING_NODE_NAME);
        this.setDisplayName(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_BugtrackingNode"));
        this.setIconBaseWithExtension(ICON_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BugtrackingRootNode getDefault() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance == null) {
                defaultInstance = new BugtrackingRootNode();
            }
            return defaultInstance;
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_CreateRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.createRepository();
            }
        }};
    }

    private static class RepositoryComparator
    implements Comparator<Repository> {
        private RepositoryComparator() {
        }

        @Override
        public int compare(Repository r1, Repository r2) {
            if (r1 == null && r2 == null) {
                return 0;
            }
            if (r1 == null) {
                return -1;
            }
            if (r2 == null) {
                return 1;
            }
            return r1.getDisplayName().compareTo(r2.getDisplayName());
        }
    }

    private static class RootNodeChildren
    extends ChildFactory<Repository>
    implements PropertyChangeListener {
        public RootNodeChildren() {
            RepositoryManager.getInstance().addPropertChangeListener((PropertyChangeListener)this);
        }

        protected Node createNodeForKey(Repository key) {
            return new RepositoryNode(key);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
                this.refresh(false);
            }
        }

        protected boolean createKeys(List<Repository> toPopulate) {
            Collection repos = RepositoryManager.getInstance().getRepositories();
            for (Repository repo : repos) {
                if (!repo.isMutable()) continue;
                toPopulate.add(repo);
            }
            Collections.sort(toPopulate, new RepositoryComparator());
            return true;
        }
    }
}

