/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.PropertyBundleSupport;
import org.netbeans.modules.properties.StructHandler;
import org.netbeans.modules.properties.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.WeakListeners;

public class BundleStructure {
    PropertiesDataObject obj;
    private PropertiesFileEntry[] entries;
    private List<String> keyList;
    private KeyComparator comparator = new KeyComparator();
    private PropertyBundleSupport propBundleSupport = new PropertyBundleSupport(this);
    private PropertyChangeListener propListener;

    protected BundleStructure() {
        this.obj = null;
    }

    public BundleStructure(PropertiesDataObject obj) {
        this.obj = obj;
        this.updateEntries();
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("files")) {
                    BundleStructure.this.updateEntries();
                    BundleStructure.this.propBundleSupport.fireBundleStructureChanged();
                }
            }
        };
        obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)obj)));
    }

    public PropertiesFileEntry getNthEntry(int index) {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        if (index >= 0 && index < this.entries.length) {
            return this.entries[index];
        }
        return null;
    }

    public int getEntryIndexByFileName(String fileName) {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        for (int i = 0; i < this.getEntryCount(); ++i) {
            if (!this.entries[i].getFile().getName().equals(fileName)) continue;
            return i;
        }
        return -1;
    }

    public PropertiesFileEntry getEntryByFileName(String fileName) {
        int index = this.getEntryIndexByFileName(fileName);
        return index == -1 ? null : this.entries[index];
    }

    public int getEntryCount() {
        if (this.entries == null) {
            this.notifyEntriesNotInitialized();
        }
        return this.entries.length;
    }

    public String[] getKeys() {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        return this.keyList.toArray(new String[0]);
    }

    public String keyAt(int keyIndex) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        if (keyIndex < 0 || keyIndex >= this.keyList.size()) {
            return null;
        }
        return this.keyList.get(keyIndex);
    }

    public int getKeyIndexByName(String key) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        return this.keyList.indexOf(key);
    }

    public String findFreeKey(String keySpec) {
        if (this.keyList == null) {
            this.notifyKeyListNotInitialized();
        }
        int n = 1;
        String key = keySpec;
        while (this.keyList.contains(key)) {
            key = keySpec + "_" + n++;
        }
        return key;
    }

    public Element.ItemElem getItem(int entryIndex, int keyIndex) {
        String key = this.keyAt(keyIndex);
        return this.getItem(entryIndex, key);
    }

    public Element.ItemElem getItem(int entryIndex, String key) {
        if (key == null) {
            return null;
        }
        PropertiesFileEntry pfe = this.getNthEntry(entryIndex);
        if (pfe == null) {
            return null;
        }
        PropertiesStructure ps = pfe.getHandler().getStructure();
        if (ps != null) {
            return ps.getItem(key);
        }
        return null;
    }

    public Element.ItemElem getItem(String localizationFile, String key) {
        int score = 0;
        Element.ItemElem item = null;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            Element.ItemElem it;
            PropertiesStructure ps;
            String fName;
            PropertiesFileEntry pfe = this.getNthEntry(i);
            if (pfe == null || !localizationFile.startsWith(fName = pfe.getFile().getName()) || item != null && fName.length() <= score || (ps = pfe.getHandler().getStructure()) == null || (it = ps.getItem(key)) == null) continue;
            item = it;
            score = fName.length();
        }
        return item;
    }

    public String[] getAllData(String key) {
        ArrayList<String> list = null;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            Element.ItemElem item;
            PropertiesStructure ps;
            PropertiesFileEntry pfe = this.getNthEntry(i);
            if (pfe == null || (ps = pfe.getHandler().getStructure()) == null || (item = ps.getItem(key)) == null) continue;
            String locale = Util.getLocaleSuffix((MultiDataObject.Entry)pfe);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(locale);
            list.add(item.getValue());
            list.add(item.getComment());
        }
        return list != null ? list.toArray(new String[list.size()]) : null;
    }

    public void setAllData(String key, String[] data) {
        String locale;
        int i;
        boolean entryCreated = false;
        for (i = 0; i < data.length; i += 3) {
            locale = data[i];
            PropertiesFileEntry localeFile = null;
            for (int j = 0; j < this.getEntryCount(); ++j) {
                PropertiesFileEntry pfe = this.getNthEntry(j);
                if (pfe == null || !Util.getLocaleSuffix((MultiDataObject.Entry)pfe).equals(locale)) continue;
                localeFile = pfe;
                break;
            }
            if (localeFile != null) continue;
            Util.createLocaleFile(this.obj, locale.substring(1), false);
            entryCreated = true;
        }
        if (entryCreated) {
            this.updateEntries();
        }
        block2: for (i = 0; i < data.length; i += 3) {
            locale = data[i];
            for (int j = 0; j < this.getEntryCount(); ++j) {
                PropertiesFileEntry pfe = this.getNthEntry(j);
                if (pfe == null || !Util.getLocaleSuffix((MultiDataObject.Entry)pfe).equals(locale)) continue;
                PropertiesStructure ps = pfe.getHandler().getStructure();
                if (ps == null) continue block2;
                Element.ItemElem item = ps.getItem(key);
                if (item != null) {
                    item.setValue(data[i + 1]);
                    item.setComment(data[i + 2]);
                    continue block2;
                }
                ps.addItem(key, data[i + 1], data[i + 2]);
                continue block2;
            }
        }
        if (this.getEntryCount() > data.length / 3) {
            for (int j = 0; j < this.getEntryCount(); ++j) {
                PropertiesFileEntry pfe = this.getNthEntry(j);
                PropertiesStructure ps = pfe.getHandler().getStructure();
                if (pfe == null || ps == null) continue;
                boolean found = false;
                for (int i2 = 0; i2 < data.length; i2 += 3) {
                    String locale2 = data[i2];
                    if (!Util.getLocaleSuffix((MultiDataObject.Entry)pfe).equals(locale2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ps.deleteItem(key);
            }
        }
    }

    public int getKeyCount() {
        if (this.keyList != null) {
            return this.keyList.size();
        }
        this.notifyKeyListNotInitialized();
        return 0;
    }

    public void addItem(String localizationFile, String key, String value, String comment, boolean changeIfExists) {
        PropertiesStructure[] ps = this.getRelatedStructures(localizationFile);
        boolean changed = false;
        for (int i = 0; i < ps.length; ++i) {
            Element.ItemElem item = ps[i].getItem(key);
            if (item != null) {
                if (!changeIfExists || changed) continue;
                item.setValue(value);
                item.setComment(comment);
                changed = true;
                continue;
            }
            ps[i].addItem(key, value, comment);
            changed = true;
        }
    }

    public void removeItem(String key) {
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesStructure ps;
            PropertiesFileEntry pfe = this.getNthEntry(i);
            if (pfe == null || (ps = pfe.getHandler().getStructure()) == null) continue;
            ps.deleteItem(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(int index) {
        if (index >= 0) {
            this.comparator.setIndex(index);
        }
        BundleStructure bundleStructure = this;
        synchronized (bundleStructure) {
            Collections.sort(this.keyList, this.comparator);
        }
        this.propBundleSupport.fireBundleDataChanged();
    }

    public int getSortIndex() {
        return this.comparator.getIndex();
    }

    public boolean getSortOrder() {
        return this.comparator.isAscending();
    }

    PropertiesOpen getOpenSupport() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEntries() {
        TreeMap<String, PropertiesFileEntry> tm = new TreeMap<String, PropertiesFileEntry>(PropertiesDataObject.getSecondaryFilesComparator());
        for (MultiDataObject.Entry entry : this.obj.secondaryEntries()) {
            tm.put(entry.getFile().getName(), (PropertiesFileEntry)entry);
        }
        BundleStructure bundleStructure = this;
        synchronized (bundleStructure) {
            int entriesCount = tm.size();
            this.entries = new PropertiesFileEntry[entriesCount + 1];
            this.entries[0] = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            int index = 0;
            for (Map.Entry mapEntry : tm.entrySet()) {
                this.entries[++index] = (PropertiesFileEntry)((Object)mapEntry.getValue());
            }
        }
        this.buildKeySet();
    }

    protected synchronized void buildKeySet() {
        ArrayList<String> keyList = new ArrayList<String>(){

            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof ArrayList)) {
                    return false;
                }
                ArrayList list2 = (ArrayList)obj;
                if (this.size() != list2.size()) {
                    return false;
                }
                for (int i = 0; i < this.size(); ++i) {
                    if (this.contains(list2.get(i)) && list2.contains(this.get(i))) continue;
                    return false;
                }
                return true;
            }
        };
        HashSet<String> interimSet = new HashSet<String>(keyList);
        int entriesCount = this.getEntryCount();
        for (int index = 0; index < entriesCount; ++index) {
            PropertiesStructure ps;
            PropertiesFileEntry entry = this.getNthEntry(index);
            if (entry == null || (ps = entry.getHandler().getStructure()) == null) continue;
            Iterator<Element.ItemElem> it = ps.allItems();
            while (it.hasNext()) {
                String key;
                Element.ItemElem item = it.next();
                if (item == null || (key = item.getKey()) == null) continue;
                interimSet.add(key);
            }
        }
        keyList.addAll(interimSet);
        Collections.sort(keyList, this.comparator);
        this.keyList = keyList;
    }

    private PropertiesStructure[] getRelatedStructures(String localizationFile) {
        ArrayList<PropertiesFileEntry> list = null;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesFileEntry pfe = this.getNthEntry(i);
            if (pfe == null || !localizationFile.startsWith(pfe.getFile().getName()) || pfe.getHandler().getStructure() == null) continue;
            if (list == null) {
                list = new ArrayList<PropertiesFileEntry>(4);
            }
            list.add(pfe);
        }
        if (list == null) {
            return new PropertiesStructure[0];
        }
        Collections.sort(list, new Comparator<PropertiesFileEntry>(){

            @Override
            public int compare(PropertiesFileEntry pfe1, PropertiesFileEntry pfe2) {
                return pfe2.getFile().getName().length() - pfe1.getFile().getName().length();
            }
        });
        PropertiesStructure[] array = new PropertiesStructure[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            array[i] = ((PropertiesFileEntry)((Object)list.get(i))).getHandler().getStructure();
        }
        return array;
    }

    boolean isReadOnly() {
        boolean canWrite = false;
        for (int i = 0; i < this.getEntryCount(); ++i) {
            PropertiesFileEntry entry = this.getNthEntry(i);
            if (entry == null) continue;
            canWrite |= entry.getFile().canWrite();
        }
        return !canWrite;
    }

    public void addPropertyBundleListener(PropertyBundleListener l) {
        if (this.propBundleSupport == null) {
            this.propBundleSupport = new PropertyBundleSupport(this);
        }
        this.propBundleSupport.addPropertyBundleListener(l);
    }

    public void removePropertyBundleListener(PropertyBundleListener l) {
        this.propBundleSupport.removePropertyBundleListener(l);
    }

    void notifyItemChanged(PropertiesStructure struct, Element.ItemElem item) {
        this.propBundleSupport.fireItemChanged(struct.getParent().getEntry().getFile().getName(), item.getKey());
    }

    void notifyOneFileChanged(FileObject file) {
        List<String> oldKeyList = this.keyList;
        this.buildKeySet();
        if (!this.keyList.equals(oldKeyList)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(file.getName());
        }
    }

    void notifyOneFileChanged(StructHandler handler) {
        List<String> oldKeyList = this.keyList;
        this.buildKeySet();
        if (!this.keyList.equals(oldKeyList)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(handler.getEntry().getFile().getName());
        }
    }

    void notifyOneFileChanged(StructHandler handler, Map<String, Element.ItemElem> itemsChanged, Map<String, Element.ItemElem> itemsAdded, Map<String, Element.ItemElem> itemsDeleted) {
        this.buildKeySet();
        this.propBundleSupport.fireBundleDataChanged();
    }

    private void notifyKeyListNotInitialized() {
        throw new IllegalStateException("Resource Bundles: KeyList not initialized");
    }

    private void notifyEntriesNotInitialized() {
        throw new IllegalStateException("Resource Bundles: Entries not initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertiesFileEntry[] getEntries() {
        BundleStructure bundleStructure = this;
        synchronized (bundleStructure) {
            if (this.entries == null) {
                return new PropertiesFileEntry[0];
            }
            return Arrays.copyOf(this.entries, this.entries.length);
        }
    }

    private final class KeyComparator
    implements Comparator<String> {
        private int index = -1;
        private boolean ascending = false;

        public void setIndex(int index) {
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (this.index == index) {
                if (this.ascending) {
                    this.ascending = false;
                } else {
                    index = -1;
                    this.ascending = true;
                }
            } else {
                this.ascending = true;
            }
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        @Override
        public int compare(String o1, String o2) {
            String str2;
            String str1;
            Element.ItemElem item2;
            Element.ItemElem item1;
            if (this.index < 0) {
                item1 = BundleStructure.this.getItem(0, o1);
                item2 = BundleStructure.this.getItem(0, o2);
                if (item1 != null && item2 != null) {
                    int i1 = item1.getBounds().getBegin().getOffset();
                    int i2 = item2.getBounds().getBegin().getOffset();
                    return i1 - i2;
                }
                if (item1 != null) {
                    return -1;
                }
                if (item2 != null) {
                    return 1;
                }
                str1 = o1;
                String string = o2;
            }
            if (this.index == 0) {
                str1 = o1;
                str2 = o2;
            } else {
                item1 = BundleStructure.this.getItem(this.index - 1, o1);
                item2 = BundleStructure.this.getItem(this.index - 1, o2);
                if (item1 == null) {
                    if (item2 == null) {
                        return 0;
                    }
                    return this.ascending ? 1 : -1;
                }
                if (item2 == null) {
                    return this.ascending ? -1 : 1;
                }
                str1 = item1.getValue();
                str2 = item2.getValue();
            }
            if (str1 == null) {
                if (str2 == null) {
                    return 0;
                }
                return this.ascending ? 1 : -1;
            }
            if (str2 == null) {
                return this.ascending ? -1 : 1;
            }
            int res = str1.compareToIgnoreCase(str2);
            return this.ascending ? res : -res;
        }
    }
}

