/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.commons.Support;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class Util {
    public static void notifyError(String title, String message) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }

    public static boolean show(JPanel panel, String title, String okName) {
        JButton ok = new JButton(okName);
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(NbBundle.getMessage(Util.class, (String)"LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, new Object[]{ok, cancel}, (Object)ok, 0, new HelpCtx(panel.getClass()), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == ok;
    }

    public static File getLargerContext(File file) {
        return Util.getLargerContext(file, null);
    }

    public static File getLargerContext(FileObject fileObj) {
        return Util.getLargerContext(null, fileObj);
    }

    public static File getLargerContext(File file, FileObject fileObj) {
        if (file == null && fileObj == null) {
            throw new IllegalArgumentException("both File and FileObject are null");
        }
        assert (file == null || fileObj == null || FileUtil.toFileObject((File)file).equals(fileObj));
        if (fileObj == null) {
            fileObj = Util.getFileObjForFileOrParent(file);
        } else if (file == null) {
            file = FileUtil.toFile((FileObject)fileObj);
        }
        if (fileObj == null) {
            return null;
        }
        if (!fileObj.isValid()) {
            return null;
        }
        FileObject parentProjectFolder = Util.getFileOwnerDirectory(fileObj);
        if (parentProjectFolder != null) {
            if (parentProjectFolder.equals(fileObj) && file != null) {
                return file;
            }
            File folder = FileUtil.toFile((FileObject)parentProjectFolder);
            if (folder != null) {
                return folder;
            }
        }
        if (fileObj.isFolder()) {
            return file;
        }
        fileObj = fileObj.getParent();
        assert (fileObj != null);
        return FileUtil.toFile((FileObject)fileObj);
    }

    private static FileObject getFileObjForFileOrParent(File file) {
        FileObject fileObj = FileUtil.toFileObject((File)file);
        if (fileObj != null) {
            return fileObj;
        }
        for (File closestParentFile = file.getParentFile(); closestParentFile != null; closestParentFile = closestParentFile.getParentFile()) {
            fileObj = FileUtil.toFileObject((File)closestParentFile);
            if (fileObj == null) continue;
            return fileObj;
        }
        return null;
    }

    public static FileObject getFileOwnerDirectory(FileObject fileObject) {
        ProjectServices projectServices = Support.getInstance().getProjectServices();
        return projectServices != null ? projectServices.getFileOwnerDirectory(fileObject) : null;
    }
}

