/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.java.metrics.hints.Bundle;
import org.netbeans.modules.java.metrics.hints.ExpressionVisitor;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ComplexArithmeticExpression {
    static final int DEFAULT_ARITHMETIC_COMPLEX_LIMIT = 5;
    public static final String OPTION_COMPLEX_ARITHMETIC_LIMIT = "metrics.expression.arithmetic.limit";

    public static List<ErrorDescription> complexArithmeticMethod(HintContext ctx) {
        return ComplexArithmeticExpression.translate(ctx);
    }

    public static List<ErrorDescription> complexArithmeticField(HintContext ctx) {
        Tree parentTree = ctx.getPath().getParentPath().getLeaf();
        if (parentTree.getKind() != Tree.Kind.CLASS && parentTree.getKind() != Tree.Kind.ENUM && parentTree.getKind() != Tree.Kind.INTERFACE) {
            return null;
        }
        ExpressionVisitor v = new ExpressionVisitor(ctx.getInfo(), false, ctx.getPreferences().getInt(OPTION_COMPLEX_ARITHMETIC_LIMIT, 5));
        return ComplexArithmeticExpression.translate(ctx);
    }

    private static List<ErrorDescription> translate(HintContext ctx) {
        ExpressionVisitor v = new ExpressionVisitor(ctx.getInfo(), false, ctx.getPreferences().getInt(OPTION_COMPLEX_ARITHMETIC_LIMIT, 5));
        v.scan(ctx.getPath(), null);
        List<TreePath> paths = v.getErrorPaths();
        if (paths.isEmpty()) {
            return null;
        }
        ArrayList<ErrorDescription> desc = new ArrayList<ErrorDescription>(paths.size());
        for (TreePath tp : paths) {
            int count = v.getNodeOperands(tp);
            desc.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)tp, (String)Bundle.TEXT_ArithmeticTooComplex(count), (Fix[])new Fix[0]));
        }
        return desc;
    }
}

