/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.CodeRefactoring;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowInputBoxParams;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.openide.filesystems.FileObject;

public final class ChangeMethodParametersRefactoring
extends CodeRefactoring {
    private static final String CHANGE_METHOD_PARAMS_REFACTORING_KIND = "refactor.change.method.params";
    private static final String CHANGE_METHOD_PARAMS_REFACTORING_COMMAND = "java.refactor.change.method.params";
    private final Set<String> commands = Collections.singleton("java.refactor.change.method.params");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        Element element;
        TreePath path;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = ChangeMethodParametersRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        String uri = Utils.toUri(info.getFileObject());
        Trees trees = info.getTrees();
        Tree.Kind kind = null;
        for (path = info.getTreeUtilities().pathFor(offset); path != null && (kind = path.getLeaf().getKind()) != Tree.Kind.METHOD && kind != Tree.Kind.METHOD_INVOCATION && kind != Tree.Kind.NEW_CLASS && kind != Tree.Kind.MEMBER_REFERENCE; path = path.getParentPath()) {
        }
        if (kind == Tree.Kind.METHOD_INVOCATION || kind == Tree.Kind.NEW_CLASS || kind == Tree.Kind.MEMBER_REFERENCE) {
            element = trees.getElement(path);
            if (element == null || element.asType().getKind() == TypeKind.ERROR) {
                return Collections.emptyList();
            }
            ExecutableElement method = (ExecutableElement)element;
            path = info.getTrees().getPath(method);
        }
        if (path == null) {
            return Collections.emptyList();
        }
        element = trees.getElement(path);
        if (!(element instanceof ExecutableElement)) {
            return Collections.emptyList();
        }
        QuickPickItem elementItem = new QuickPickItem(ChangeMethodParametersRefactoring.createLabel((CompilationInfo)info, element, true));
        elementItem.setUserData(new CodeActionsProvider.ElementData(element));
        return Collections.singletonList(ChangeMethodParametersRefactoring.createCodeAction(Bundle.DN_ChangeMethodParams(), CHANGE_METHOD_PARAMS_REFACTORING_KIND, CHANGE_METHOD_PARAMS_REFACTORING_COMMAND, uri, elementItem));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        try {
            if (arguments.size() <= 1) {
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            QuickPickItem sourceItem = (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(1)), QuickPickItem.class);
            String label = sourceItem.getLabel();
            int idx = label.indexOf(40);
            client.showInputBox(new ShowInputBoxParams(Bundle.DN_ChangeMethodSignature(), label.substring(idx))).thenAccept(signature -> {
                if (signature != null && !signature.isEmpty()) {
                    this.changeMethodParams(client, uri, sourceItem, (String)signature);
                }
            });
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void changeMethodParams(NbCodeLanguageClient client, String uri, QuickPickItem source, String signature) {
        try {
            FileObject file = Utils.fromUri(uri);
            ClasspathInfo info = ClasspathInfo.create((FileObject)file);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            ElementHandle handle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(source.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
            AtomicReference params = new AtomicReference();
            StringBuilder ret = new StringBuilder();
            js.runUserActionTask(ci -> {
                ExecutableElement el;
                TreePath path;
                ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement method = (ExecutableElement)handle.resolve((CompilationInfo)ci);
                if (method != null && (path = ci.getTrees().getPath(method)) != null && (el = ChangeMethodParametersRefactoring.fromSignature((CompilationInfo)ci, signature, path)) != null) {
                    if (method.getReturnType() != el.getReturnType()) {
                        ret.append(Utilities.getTypeName((CompilationInfo)ci, (TypeMirror)el.getReturnType(), (boolean)true));
                    }
                    params.set(ChangeMethodParametersRefactoring.matchParameters((CompilationInfo)ci, el.getParameters(), method.getParameters()));
                }
            }, true);
            if (params.get() == null) {
                throw new IllegalArgumentException("Error while parsing new method signature.");
            }
            ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring(TreePathHandle.from((ElementHandle)handle, (ClasspathInfo)info));
            refactoring.setReturnType(ret.length() > 0 ? ret.toString() : null);
            refactoring.setParameterInfo((ChangeParametersRefactoring.ParameterInfo[])params.get());
            refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{file}));
            client.applyEdit(new ApplyWorkspaceEditParams(this.perform((AbstractRefactoring)refactoring, "ChangeMethodParameters")));
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }

    private static ExecutableElement fromSignature(CompilationInfo info, String signature, TreePath path) {
        int idx = signature.lastIndexOf(58);
        StringBuilder toParse = new StringBuilder("{class _X { public ");
        if (idx < 0) {
            toParse.append("_X").append(signature);
        } else {
            toParse.append(signature.substring(idx + 1)).append(" m").append(signature.substring(0, idx));
        }
        toParse.append("{}}}");
        SourcePositions[] sp = new SourcePositions[1];
        TreeUtilities treeUtilities = info.getTreeUtilities();
        StatementTree stmt = treeUtilities.parseStatement(toParse.toString(), sp);
        if (stmt != null && stmt.getKind() == Tree.Kind.BLOCK) {
            treeUtilities.attributeTree((Tree)stmt, info.getTrees().getScope(path));
            List<? extends StatementTree> stmts = ((BlockTree)stmt).getStatements();
            if (!stmts.isEmpty() && stmts.get(0).getKind() == Tree.Kind.CLASS) {
                ClassTree ct = (ClassTree)stmts.get(0);
                for (Tree tree : ct.getMembers()) {
                    Element element;
                    TreePath memberPath = new TreePath(path, tree);
                    if (treeUtilities.isSynthetic(memberPath) || tree.getKind() != Tree.Kind.METHOD || (element = info.getTrees().getElement(memberPath)) == null || element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR) continue;
                    return (ExecutableElement)element;
                }
            }
        }
        return null;
    }

    private static ChangeParametersRefactoring.ParameterInfo[] matchParameters(CompilationInfo info, List<? extends VariableElement> params, List<? extends VariableElement> orig) {
        VariableElement origParam;
        int i;
        VariableElement param;
        int idx;
        ChangeParametersRefactoring.ParameterInfo[] result = new ChangeParametersRefactoring.ParameterInfo[params.size()];
        boolean[] used = new boolean[orig.size()];
        for (idx = 0; idx < params.size(); ++idx) {
            param = params.get(idx);
            for (i = 0; i < orig.size(); ++i) {
                if (used[i] || !(origParam = orig.get(i)).getSimpleName().contentEquals(param.getSimpleName())) continue;
                result[idx] = new ChangeParametersRefactoring.ParameterInfo(i, param.getSimpleName().toString(), Utilities.getTypeName((CompilationInfo)info, (TypeMirror)param.asType(), (boolean)true).toString(), null);
                used[i] = true;
            }
        }
        for (idx = 0; idx < params.size(); ++idx) {
            if (result[idx] != null) continue;
            param = params.get(idx);
            for (i = 0; i < orig.size(); ++i) {
                if (used[i] || (origParam = orig.get(i)).asType() != param.asType()) continue;
                result[idx] = new ChangeParametersRefactoring.ParameterInfo(i, param.getSimpleName().toString(), Utilities.getTypeName((CompilationInfo)info, (TypeMirror)param.asType(), (boolean)true).toString(), null);
                used[i] = true;
            }
        }
        for (idx = 0; idx < params.size(); ++idx) {
            if (result[idx] != null) continue;
            param = params.get(idx);
            result[idx] = idx >= orig.size() || used[idx] ? new ChangeParametersRefactoring.ParameterInfo(-1, param.getSimpleName().toString(), Utilities.getTypeName((CompilationInfo)info, (TypeMirror)param.asType(), (boolean)true).toString(), ChangeMethodParametersRefactoring.defaultValue(param)) : new ChangeParametersRefactoring.ParameterInfo(idx, param.getSimpleName().toString(), Utilities.getTypeName((CompilationInfo)info, (TypeMirror)param.asType(), (boolean)true).toString(), null);
        }
        return result;
    }

    private static String defaultValue(VariableElement param) {
        switch (param.asType().getKind()) {
            case ARRAY: 
            case DECLARED: {
                return "null";
            }
            case BOOLEAN: {
                return "false";
            }
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return "0";
            }
        }
        return null;
    }
}

