/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.encoding.simpletype.XSDDateTimeCalendarEncoder;
import com.sun.xml.rpc.processor.util.PrettyPrintingXMLWriterFactoryImpl;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.QName;

public abstract class ExporterBase {
    protected OutputStream out;
    protected XMLWriter writer;
    protected Map obj2id;
    protected Map immutableObj2id;
    protected int nextId;
    protected Set obj2serialize;
    protected Stack obj2serializeStack;
    protected Set immediateClasses;
    protected Set immutableClasses;
    protected static final QName DEF_OBJ_NAME = new QName("object");
    protected static final QName DEF_IMM_OBJ_NAME = new QName("iobject");
    protected static final QName PROP_NAME = new QName("property");
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_SUBJECT = "subject";

    public ExporterBase(OutputStream s) {
        this.out = s;
        try {
            this.writer = new PrettyPrintingXMLWriterFactoryImpl().createXMLWriter(new GZIPOutputStream(s));
        }
        catch (IOException e) {
            throw new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(e));
        }
        this.writer.setPrefixFactory(new PrefixFactoryImpl("ns"));
    }

    protected void initialize() {
        this.obj2id = new IdentityHashMap();
        this.immutableObj2id = new HashMap();
        this.obj2serialize = new HashSet();
        this.obj2serializeStack = new Stack();
        this.nextId = 1;
        this.immutableClasses = new HashSet();
        this.immutableClasses.add(Boolean.class);
        this.immutableClasses.add(Integer.class);
        this.immutableClasses.add(Short.class);
        this.immutableClasses.add(Long.class);
        this.immutableClasses.add(Float.class);
        this.immutableClasses.add(Double.class);
        this.immutableClasses.add(Byte.class);
        this.immutableClasses.add(String.class);
        this.immutableClasses.add(BigDecimal.class);
        this.immutableClasses.add(BigInteger.class);
        this.immutableClasses.add(QName.class);
        this.immutableClasses.add(SOAPStyle.class);
        this.immutableClasses.add(SOAPUse.class);
        this.immutableClasses.add(SOAPVersion.class);
        this.immutableClasses.add(URI.class);
        this.immediateClasses = new HashSet();
        this.immediateClasses.addAll(this.immutableClasses);
        try {
            this.immediateClasses.add(Class.forName("[I"));
            this.immediateClasses.add(Class.forName("[B"));
            this.immediateClasses.add(Class.forName("[Ljava.lang.String;"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.immediateClasses.add(ArrayList.class);
        this.immediateClasses.add(HashSet.class);
        this.immediateClasses.add(HashMap.class);
        this.immediateClasses.add(GregorianCalendar.class);
    }

    protected void internalDoExport(Object root) {
        this.initialize();
        this.writer.startElement(this.getContainerName());
        if (this.getVersion() != null) {
            int[] version = VersionUtil.getCanonicalVersion(this.getVersion());
            this.writer.writeAttribute(ATTR_VERSION, version[0] + "." + version[1] + "." + version[2] + "." + version[3]);
        }
        int id = this.getId(root);
        while (!this.obj2serializeStack.empty()) {
            Object obj = this.obj2serializeStack.pop();
            this.obj2serialize.remove(obj);
            this.visit(obj);
        }
        this.writer.endElement();
        this.writer.close();
    }

    protected void visit(Object obj) {
        if (obj == null) {
            return;
        }
        this.failUnsupportedClass(obj.getClass());
    }

    protected boolean isImmediate(Object obj) {
        if (obj == null) {
            return true;
        }
        return this.immediateClasses.contains(obj.getClass());
    }

    protected boolean isImmutable(Object obj) {
        if (obj == null) {
            return true;
        }
        return this.immutableClasses.contains(obj.getClass());
    }

    protected int getId(Object obj) {
        if (obj == null) {
            return 0;
        }
        Integer id = (Integer)this.obj2id.get(obj);
        if (id != null) {
            return id;
        }
        boolean immutable = this.isImmutable(obj);
        if (immutable && (id = (Integer)this.immutableObj2id.get(obj)) != null) {
            return id;
        }
        id = this.newId();
        this.obj2id.put(obj, id);
        if (immutable) {
            this.immutableObj2id.put(obj, id);
        }
        if (this.isImmediate(obj)) {
            this.defineImmediate(obj, id);
        } else {
            this.define(obj, id);
        }
        return id;
    }

    protected void defineImmediate(Object obj, Integer id) {
        String value = this.getImmediateObjectValue(obj);
        this.writer.startElement(this.getDefineImmediateObjectName());
        this.writer.writeAttribute(ATTR_ID, id.toString());
        this.writer.writeAttribute(ATTR_TYPE, obj.getClass().getName());
        this.writer.writeAttribute(ATTR_VALUE, value);
        this.writer.endElement();
    }

    protected String getImmediateObjectValue(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof QName) {
            return obj.toString();
        }
        if (obj instanceof Boolean || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Byte || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof SOAPStyle) {
            return obj == SOAPStyle.RPC ? "rpc" : "document";
        }
        if (obj instanceof SOAPUse) {
            return obj == SOAPUse.ENCODED ? "encoded" : "literal";
        }
        if (obj instanceof SOAPVersion) {
            return obj.toString();
        }
        if (obj instanceof int[]) {
            int[] a = (int[])obj;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(a[i]));
            }
            return sb.toString();
        }
        if (obj instanceof byte[]) {
            byte[] a = (byte[])obj;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(Byte.toString(a[i]));
            }
            return sb.toString();
        }
        if (obj instanceof String[]) {
            String[] a = (String[])obj;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(a[i]);
            }
            return sb.toString();
        }
        if (obj instanceof ArrayList) {
            ArrayList a = (ArrayList)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (Object element : a) {
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(element)));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof HashSet) {
            HashSet s = (HashSet)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (Object element : s) {
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(element)));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof HashMap) {
            HashMap m = (HashMap)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (Map.Entry entry : m.entrySet()) {
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(entry.getKey())));
                sb.append(' ');
                sb.append(Integer.toString(this.getId(entry.getValue())));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof GregorianCalendar) {
            try {
                return XSDDateTimeCalendarEncoder.getInstance().objectToString(obj, null);
            }
            catch (Exception e) {
                this.failUnsupportedClass(obj.getClass());
                return "UNKOWN";
            }
        }
        this.failUnsupportedClass(obj.getClass());
        return "UNKOWN";
    }

    protected void define(Object obj, Integer id) {
        this.writer.startElement(this.getDefineObjectName());
        this.writer.writeAttribute(ATTR_ID, id.toString());
        this.writer.writeAttribute(ATTR_TYPE, obj.getClass().getName());
        this.writer.endElement();
        this.obj2serialize.add(obj);
        this.obj2serializeStack.push(obj);
    }

    protected void property(String name, Object subject, Object object) {
        int sid = this.getId(subject);
        int oid = this.getId(object);
        this.writer.startElement(this.getPropertyName());
        this.writer.writeAttribute(ATTR_NAME, name);
        this.writer.writeAttribute(ATTR_SUBJECT, Integer.toString(sid));
        this.writer.writeAttribute(ATTR_VALUE, Integer.toString(oid));
        this.writer.endElement();
    }

    protected Integer newId() {
        return new Integer(this.nextId++);
    }

    protected abstract QName getContainerName();

    protected String getVersion() {
        return null;
    }

    protected QName getDefineObjectName() {
        return DEF_OBJ_NAME;
    }

    protected QName getDefineImmediateObjectName() {
        return DEF_IMM_OBJ_NAME;
    }

    protected QName getPropertyName() {
        return PROP_NAME;
    }

    protected abstract void failUnsupportedClass(Class var1);
}

