/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.component.selectcheckboxmenu.SelectCheckboxMenu;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCheckboxMenuRenderer
extends org.primefaces.component.selectcheckboxmenu.SelectCheckboxMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("SelectCheckboxMenu", menu.resolveWidgetVar(), clientId).finish();
    }

    @Override
    public void encodeMarkup(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        String clientId = menu.getClientId(context);
        writer.startElement("select", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("data-role", (Object)"none", null);
        if (menu.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (menu.getOnkeydown() != null) {
            writer.writeAttribute("onkeydown", (Object)menu.getOnkeydown(), null);
        }
        if (menu.getOnkeyup() != null) {
            writer.writeAttribute("onkeyup", (Object)menu.getOnkeyup(), null);
        }
        this.renderOnchange(context, (UIComponent)menu);
        this.renderDynamicPassThruAttributes(context, (UIComponent)menu);
        this.encodeSelectItems(context, menu, selectItems, values, submittedValues, converter);
        writer.endElement("select");
    }

    protected void encodeSelectItems(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems, Object values, Object submittedValues, Converter converter) throws IOException {
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (option instanceof SelectItemGroup) {
            SelectItemGroup group = (SelectItemGroup)option;
            for (SelectItem groupItem : group.getSelectItems()) {
                this.encodeOption(context, menu, groupItem, values, submittedValues, converter);
            }
        } else {
            Object itemValue;
            Object valuesArray;
            String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
            boolean disabled = option.isDisabled();
            if (submittedValues != null) {
                valuesArray = submittedValues;
                itemValue = itemValueAsString;
            } else {
                valuesArray = values;
                itemValue = option.getValue();
            }
            boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)itemValueAsString, null);
            if (disabled) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            if (selected) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (!this.isValueBlank(option.getLabel())) {
                if (option.isEscape()) {
                    writer.writeText((Object)option.getLabel(), "value");
                } else {
                    writer.write(option.getLabel());
                }
            }
            writer.endElement("option");
        }
    }
}

