/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIData;
import org.primefaces.component.paginator.CurrentPageReportRenderer;
import org.primefaces.component.paginator.FirstPageLinkRenderer;
import org.primefaces.component.paginator.JumpToPageDropdownRenderer;
import org.primefaces.component.paginator.LastPageLinkRenderer;
import org.primefaces.component.paginator.NextPageLinkRenderer;
import org.primefaces.component.paginator.PageLinksRenderer;
import org.primefaces.component.paginator.PaginatorElementRenderer;
import org.primefaces.component.paginator.PrevPageLinkRenderer;
import org.primefaces.component.paginator.RowsPerPageDropdownRenderer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class DataRenderer
extends CoreRenderer {
    private static Map<String, PaginatorElementRenderer> PAGINATOR_ELEMENTS = new HashMap<String, PaginatorElementRenderer>();

    protected void encodePaginatorMarkup(FacesContext context, UIData uidata, String position) throws IOException {
        String[] elements;
        if (!uidata.isPaginatorAlwaysVisible() && uidata.getPageCount() <= 1) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean isTop = position.equals("top");
        String styleClass = isTop ? "ui-paginator ui-paginator-top ui-widget-header" : "ui-paginator ui-paginator-bottom ui-widget-header";
        String id = uidata.getClientId(context) + "_paginator_" + position;
        if (!isTop && uidata.getFooter() == null) {
            styleClass = styleClass + " ui-corner-bottom";
        } else if (isTop && uidata.getHeader() == null) {
            styleClass = styleClass + " ui-corner-top";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"navigation", null);
        for (String element : elements = uidata.getPaginatorTemplate().split(" ")) {
            PaginatorElementRenderer renderer = PAGINATOR_ELEMENTS.get(element);
            if (renderer != null) {
                renderer.render(context, uidata);
                continue;
            }
            writer.write(element + " ");
        }
        writer.endElement("div");
    }

    protected void encodePaginatorConfig(FacesContext context, UIData uidata, WidgetBuilder wb) throws IOException {
        String clientId = uidata.getClientId(context);
        String paginatorPosition = uidata.getPaginatorPosition();
        String paginatorContainers = null;
        String currentPageTemplate = uidata.getCurrentPageReportTemplate();
        paginatorContainers = paginatorPosition.equalsIgnoreCase("both") ? "'" + clientId + "_paginator_top','" + clientId + "_paginator_bottom'" : "'" + clientId + "_paginator_" + paginatorPosition + "'";
        wb.append(",paginator:{").append("id:[").append(paginatorContainers).append("]").append(",rows:").append(uidata.getRows()).append(",rowCount:").append(uidata.getRowCount()).append(",page:").append(uidata.getPage());
        if (currentPageTemplate != null) {
            wb.append(",currentPageTemplate:'").append(currentPageTemplate).append("'");
        }
        if (uidata.getPageLinks() != 10) {
            wb.append(",pageLinks:").append(uidata.getPageLinks());
        }
        if (!uidata.isPaginatorAlwaysVisible()) {
            wb.append(",alwaysVisible:false");
        }
        wb.append("}");
    }

    public void encodeFacet(FacesContext context, UIData data, String facet, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent component = data.getFacet(facet);
        if (component != null && component.isRendered()) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            component.encodeAll(context);
            writer.endElement("div");
        }
    }

    static {
        PAGINATOR_ELEMENTS.put("{CurrentPageReport}", new CurrentPageReportRenderer());
        PAGINATOR_ELEMENTS.put("{FirstPageLink}", new FirstPageLinkRenderer());
        PAGINATOR_ELEMENTS.put("{PreviousPageLink}", new PrevPageLinkRenderer());
        PAGINATOR_ELEMENTS.put("{NextPageLink}", new NextPageLinkRenderer());
        PAGINATOR_ELEMENTS.put("{LastPageLink}", new LastPageLinkRenderer());
        PAGINATOR_ELEMENTS.put("{PageLinks}", new PageLinksRenderer());
        PAGINATOR_ELEMENTS.put("{RowsPerPageDropdown}", new RowsPerPageDropdownRenderer());
        PAGINATOR_ELEMENTS.put("{JumpToPageDropdown}", new JumpToPageDropdownRenderer());
    }
}

