/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.ArchiveTypeBindingTypeFilter;
import org.netbeans.modules.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.web.beans.impl.model.DefaultBindingTypeFilter;
import org.netbeans.modules.web.beans.impl.model.MemberBindingFilter;
import org.netbeans.modules.web.beans.impl.model.RestrictedTypedFilter;
import org.netbeans.modules.web.beans.impl.model.ResultLookupStrategy;
import org.netbeans.modules.web.beans.impl.model.TypeBindingFilter;
import org.netbeans.modules.web.beans.impl.model.TypeProductionFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;
import org.netbeans.modules.web.beans.impl.model.results.DefinitionErrorResult;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;
import org.openide.util.NbBundle;

abstract class FieldInjectionPointLogic {
    static final String PRODUCER_ANNOTATION = "javax.enterprise.inject.Produces";
    static final String ANY_QUALIFIER_ANNOTATION = "javax.enterprise.inject.Any";
    static final String DEFAULT_QUALIFIER_ANNOTATION = "javax.enterprise.inject.Default";
    static final String NEW_QUALIFIER_ANNOTATION = "javax.enterprise.inject.New";
    static final String NAMED_QUALIFIER_ANNOTATION = "javax.inject.Named";
    static final String INJECT_ANNOTATION = "javax.inject.Inject";
    static final String INSTANCE_INTERFACE = "javax.enterprise.inject.Instance";
    static final String TYPED_RESTRICTION = "javax.enterprise.inject.Typed";
    static final String DELEGATE_ANNOTATION = "javax.decorator.Delegate";
    static final Logger LOGGER = Logger.getLogger(WebBeansModelProvider.class.getName());
    private WebBeansModelImplementation myModel;

    FieldInjectionPointLogic(WebBeansModelImplementation model) {
        this.myModel = model;
    }

    public abstract TypeMirror resolveType(String var1);

    protected WebBeansModelImplementation getModel() {
        return this.myModel;
    }

    protected DependencyInjectionResult findVariableInjectable(VariableElement element, DeclaredType parentType, ResultLookupStrategy strategy, AtomicBoolean cancel) {
        List<? extends TypeMirror> typeArguments;
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType);
        }
        catch (DefinitionError e) {
            TypeElement type = e.getElement();
            return new DefinitionErrorResult(element, parentType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_BadParent", (Object)element.getSimpleName(), (Object)(type != null ? type.toString() : null)));
        }
        if (cancel.get()) {
            return null;
        }
        TypeMirror elementType = strategy.getType(this.getModel(), parent, element);
        if (elementType instanceof DeclaredType && "javax.inject.Provider".equals("" + ((DeclaredType)elementType).asElement()) && (typeArguments = ((DeclaredType)elementType).getTypeArguments()) != null && typeArguments.size() > 0) {
            elementType = typeArguments.get(0);
        }
        DependencyInjectionResult result = this.doFindVariableInjectable(element, elementType, true, cancel);
        return strategy.getResult(this.getModel(), result, cancel);
    }

    protected DeclaredType getParent(Element element, DeclaredType parentType) throws DefinitionError {
        DeclaredType parent = parentType;
        if (parent == null) {
            TypeElement type = this.getModel().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            boolean isDeclaredType = type.asType() instanceof DeclaredType;
            if (isDeclaredType) {
                parent = (DeclaredType)type.asType();
            } else {
                throw new DefinitionError(type);
            }
        }
        return parent;
    }

    protected DependencyInjectionResult doFindVariableInjectable(VariableElement element, TypeMirror elementType, boolean injectRequired, AtomicBoolean cancel) {
        Set<Element> productionElements;
        AnnotationMirror annotationMirror;
        DeclaredType type;
        TypeElement annotationElement;
        LinkedList<AnnotationMirror> quilifierAnnotations = new LinkedList<AnnotationMirror>();
        boolean anyQualifier = false;
        try {
            anyQualifier = this.hasAnyQualifier(element, injectRequired, false, quilifierAnnotations);
        }
        catch (InjectionPointDefinitionError e) {
            return new DefinitionErrorResult(element, elementType, e.getMessage());
        }
        boolean defaultQualifier = !anyQualifier && quilifierAnnotations.size() == 0;
        boolean newQualifier = false;
        String annotationName = null;
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        if (quilifierAnnotations.size() == 1 && (annotationElement = (TypeElement)(type = (annotationMirror = (AnnotationMirror)quilifierAnnotations.get(0)).getAnnotationType()).asElement()) != null) {
            annotationName = annotationElement.getQualifiedName().toString();
            defaultQualifier = annotationElement.getQualifiedName().contentEquals(DEFAULT_QUALIFIER_ANNOTATION);
            newQualifier = annotationElement.getQualifiedName().contentEquals(NEW_QUALIFIER_ANNOTATION);
        }
        if (quilifierAnnotations.size() == 0 && anyQualifier || defaultQualifier) {
            HashSet<TypeElement> assignableTypes;
            LOGGER.fine("Found built-in binding " + annotationName);
            Set<TypeElement> set = assignableTypes = cancel.get() ? new HashSet<TypeElement>() : this.getAssignableTypes(element, elementType, cancel);
            if (defaultQualifier) {
                LOGGER.fine("@Default annotation requires test for implementors of varaible type");
                this.filterBindingsByDefault(assignableTypes);
                this.filterBindingByArchiveType(assignableTypes);
            }
            types.addAll(assignableTypes);
        } else {
            if (newQualifier) {
                return this.handleNewQualifier(element, elementType, quilifierAnnotations);
            }
            Set<TypeElement> typesWithQualifiers = this.getBindingTypes(quilifierAnnotations);
            this.filterBindingsByMembers(quilifierAnnotations, typesWithQualifiers, TypeElement.class);
            this.filterBindingsByType(element, elementType, typesWithQualifiers);
            types.addAll(typesWithQualifiers);
        }
        if (quilifierAnnotations.size() == 0 && anyQualifier || defaultQualifier) {
            productionElements = this.getAllProductions();
            if (defaultQualifier) {
                this.filterDefaultProductions(productionElements);
            }
        } else {
            productionElements = this.getProductions(quilifierAnnotations, cancel);
            this.filterBindingsByMembers(quilifierAnnotations, productionElements, Element.class);
        }
        this.filterProductionByType(element, elementType, productionElements);
        return this.createResult(element, elementType, types, productionElements);
    }

    protected boolean isQualifier(TypeElement element, AnnotationModelHelper helper, boolean event) {
        return AnnotationObjectProvider.isQualifier(element, helper, event);
    }

    protected Set<Element> getChildSpecializes(Element productionElement, WebBeansModelImplementation model, AtomicBoolean cancel) {
        TypeElement typeElement = model.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(productionElement);
        Set<TypeElement> implementors = FieldInjectionPointLogic.getImplementors(model, typeElement, cancel);
        implementors.remove(productionElement.getEnclosingElement());
        HashSet<Element> specializeElements = new HashSet<Element>();
        specializeElements.add(productionElement);
        for (TypeElement implementor : implementors) {
            if (cancel.get()) break;
            this.inspectHierarchy(productionElement, implementor, specializeElements, model);
        }
        specializeElements.remove(productionElement);
        return specializeElements;
    }

    protected boolean hasAnyQualifier(VariableElement element, boolean injectRequired, boolean eventQualifiers, List<AnnotationMirror> quilifierAnnotations) throws InjectionPointDefinitionError {
        List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        boolean isProducer = false;
        boolean anyQualifier = false;
        boolean hasInject = false;
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (annotationElement == null) continue;
            if (ANY_QUALIFIER_ANNOTATION.equals(annotationElement.getQualifiedName().toString())) {
                anyQualifier = true;
            } else if (this.isQualifier(annotationElement, this.getModel().getHelper(), eventQualifiers)) {
                quilifierAnnotations.add(annotationMirror);
            }
            if (PRODUCER_ANNOTATION.contentEquals(annotationElement.getQualifiedName())) {
                isProducer = true;
                continue;
            }
            if (!INJECT_ANNOTATION.contentEquals(annotationElement.getQualifiedName())) continue;
            hasInject = true;
        }
        if (isProducer) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_ProducerInjectPoint", (Object)element.getSimpleName()));
        }
        if (element.asType().getKind() == TypeKind.TYPEVAR) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_InjectPointTypeVar", (Object)element.getSimpleName()));
        }
        if (injectRequired) {
            this.checkInjectionPoint(element);
        }
        if (injectRequired && !hasInject) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_NoInjectPoint", (Object)element.getSimpleName()));
        }
        return anyQualifier;
    }

    private void checkInjectionPoint(VariableElement element) throws InjectionPointDefinitionError {
        VariableTree varTree;
        ExpressionTree initializer;
        CompilationController compilationController = this.getModel().getHelper().getCompilationController();
        Tree tree = compilationController.getTrees().getTree(element);
        if (tree instanceof VariableTree && (initializer = (varTree = (VariableTree)tree).getInitializer()) != null) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(FieldInjectionPointLogic.class, (String)"ERR_InitializedInjectionPoint"));
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC)) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(FieldInjectionPointLogic.class, (String)"ERR_StaticInjectionPoint"));
        }
        if (modifiers.contains((Object)Modifier.FINAL)) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(FieldInjectionPointLogic.class, (String)"ERR_FinalInjectionPoint"));
        }
    }

    protected <T extends Element> void filterBindingsByMembers(Collection<AnnotationMirror> bindingAnnotations, Set<T> elementsWithBindings, Class<T> clazz) {
        MemberBindingFilter<T> filter = MemberBindingFilter.get(clazz);
        filter.init(bindingAnnotations, this.getModel());
        filter.filter(elementsWithBindings);
    }

    protected void filterBindingsByType(VariableElement element, TypeMirror elementType, Set<TypeElement> typesWithBindings) {
        TypeBindingFilter filter = TypeBindingFilter.get();
        filter.init(elementType, element, this.getModel());
        filter.filter(typesWithBindings);
    }

    protected ResultImpl handleNewQualifier(VariableElement element, TypeMirror elementType, List<AnnotationMirror> quilifierAnnotations) {
        AnnotationMirror annotationMirror = quilifierAnnotations.get(0);
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getModel().getHelper());
        parser.expectClass("value", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        String clazz = (String)parseResult.get("value", String.class);
        TypeMirror typeMirror = clazz == null ? elementType : this.resolveType(clazz);
        Element typeElement = null;
        if (typeMirror != null) {
            typeElement = this.getModel().getHelper().getCompilationController().getTypes().asElement(typeMirror);
        }
        if (typeElement != null && this.getModel().getHelper().getCompilationController().getTypes().isAssignable(typeMirror, elementType)) {
            return new ResultImpl(element, elementType, (TypeElement)typeElement, this.getModel().getHelper());
        }
        return new ResultImpl(element, elementType, this.getModel().getHelper());
    }

    static Set<TypeElement> getImplementors(WebBeansModelImplementation modelImpl, Element typeElement, AtomicBoolean cancel) {
        if (!(typeElement instanceof TypeElement)) {
            return Collections.emptySet();
        }
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        result.add((TypeElement)typeElement);
        HashSet<TypeElement> toProcess = new HashSet<TypeElement>();
        toProcess.add((TypeElement)typeElement);
        while (toProcess.size() > 0 && !cancel.get()) {
            TypeElement element = (TypeElement)toProcess.iterator().next();
            toProcess.remove(element);
            Set<TypeElement> set = FieldInjectionPointLogic.doGetImplementors(modelImpl, element, cancel);
            if (set.size() == 0) continue;
            result.addAll(set);
            for (TypeElement impl : set) {
                toProcess.add(impl);
            }
        }
        return result;
    }

    private DependencyInjectionResult createResult(VariableElement element, TypeMirror elementType, Set<TypeElement> types, Set<Element> productions) {
        return new ResultImpl(element, elementType, types, productions, this.getModel().getHelper());
    }

    private void inspectHierarchy(Element productionElement, TypeElement implementor, Set<Element> specializeElements, WebBeansModelImplementation model) {
        List<? extends Element> enclosedElements = implementor.getEnclosedElements();
        for (Element element : enclosedElements) {
            HashSet<Element> probableSpecializes;
            if (element.getKind() != ElementKind.METHOD || !productionElement.getSimpleName().contentEquals(element.getSimpleName()) || !this.collectSpecializes(productionElement, (ExecutableElement)element, model, probableSpecializes = new HashSet<Element>(), specializeElements)) continue;
            specializeElements.addAll(probableSpecializes);
            return;
        }
    }

    private boolean collectSpecializes(Element productionElement, ExecutableElement element, WebBeansModelImplementation model, Set<Element> probableSpecializes, Set<Element> specializeElements) {
        ElementUtilities elementUtilities = model.getHelper().getCompilationController().getElementUtilities();
        if (!elementUtilities.overridesMethod(element)) {
            return false;
        }
        ExecutableElement overriddenMethod = elementUtilities.getOverriddenMethod(element);
        if (overriddenMethod == null) {
            return false;
        }
        if (!AnnotationObjectProvider.hasSpecializes(element, model.getHelper())) {
            return false;
        }
        probableSpecializes.add(element);
        if (overriddenMethod.equals(productionElement) || specializeElements.contains(productionElement)) {
            return true;
        }
        return this.collectSpecializes(productionElement, overriddenMethod, model, probableSpecializes, specializeElements);
    }

    private static Set<TypeElement> doGetImplementors(WebBeansModelImplementation modelImpl, TypeElement typeElement, AtomicBoolean cancel) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        ElementHandle handle = ElementHandle.create((Element)typeElement);
        ClassIndex classIndex = modelImpl.getHelper().getClasspathInfo().getClassIndex();
        if (cancel.get()) {
            return Collections.emptySet();
        }
        Set handles = classIndex.getElements(handle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (handles == null) {
            LOGGER.log(Level.WARNING, "ClassIndex.getElements() was interrupted");
            return Collections.emptySet();
        }
        for (ElementHandle elementHandle : handles) {
            if (cancel.get()) {
                return Collections.emptySet();
            }
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle.getQualifiedName());
            TypeElement derivedElement = (TypeElement)elementHandle.resolve((CompilationInfo)modelImpl.getHelper().getCompilationController());
            if (derivedElement == null) continue;
            result.add(derivedElement);
        }
        return result;
    }

    private void filterDefaultProductions(Set<Element> productionElements) {
        DefaultBindingTypeFilter<Element> filter = DefaultBindingTypeFilter.get(Element.class);
        filter.init(this.getModel());
        filter.filter(productionElements);
    }

    private Set<Element> getAllProductions() {
        final HashSet<Element> result = new HashSet<Element>();
        try {
            this.getModel().getHelper().getAnnotationScanner().findAnnotations(PRODUCER_ANNOTATION, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    result.add(element);
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.warning("Finding annotation javax.enterprise.inject.Produces was interrupted");
        }
        return result;
    }

    private void filterProductionByType(VariableElement element, TypeMirror elementType, Set<Element> productionElements) {
        TypeProductionFilter filter = TypeProductionFilter.get();
        filter.init(elementType, element, this.getModel());
        filter.filter(productionElements);
    }

    private void filterBindingsByDefault(Set<TypeElement> assignableTypes) {
        DefaultBindingTypeFilter<TypeElement> filter = DefaultBindingTypeFilter.get(TypeElement.class);
        filter.init(this.getModel());
        filter.filter(assignableTypes);
    }

    private void filterBindingByArchiveType(Set<TypeElement> assignableTypes) {
        ArchiveTypeBindingTypeFilter<TypeElement> filter = ArchiveTypeBindingTypeFilter.get(TypeElement.class);
        filter.init(this.getModel());
        filter.filter(assignableTypes);
    }

    private Set<TypeElement> getAssignableTypes(VariableElement element, TypeMirror elementType, AtomicBoolean cancel) {
        if (elementType.getKind() != TypeKind.DECLARED) {
            return Collections.emptySet();
        }
        Element typeElement = ((DeclaredType)elementType).asElement();
        if (!(typeElement instanceof TypeElement)) {
            return Collections.emptySet();
        }
        if (!((TypeElement)typeElement).getTypeParameters().isEmpty()) {
            return this.getAssignables(elementType, (TypeElement)typeElement, element, cancel);
        }
        Set<TypeElement> implementors = FieldInjectionPointLogic.getImplementors(this.getModel(), typeElement, cancel);
        this.restrictedTypeFilter(implementors, (TypeElement)typeElement);
        return implementors;
    }

    private void restrictedTypeFilter(Set<TypeElement> allImplementors, TypeElement originalElement) {
        RestrictedTypedFilter filter = new RestrictedTypedFilter();
        filter.init(originalElement, this.getModel());
        filter.filter(allImplementors);
    }

    private Set<TypeElement> getAssignables(TypeMirror elementType, TypeElement typeElement, VariableElement element, AtomicBoolean cancel) {
        Set<TypeElement> result = FieldInjectionPointLogic.getImplementors(this.getModel(), typeElement, cancel);
        TypeBindingFilter filter = TypeBindingFilter.get();
        filter.init(elementType, element, this.getModel());
        filter.filter(result);
        return result;
    }

    private Set<Element> getProductions(List<AnnotationMirror> qualifierAnnotations, AtomicBoolean cancel) {
        ArrayList<Set<Element>> bindingCollections = new ArrayList<Set<Element>>(qualifierAnnotations.size());
        boolean hasDefault = this.getModel().getHelper().getAnnotationsByType(qualifierAnnotations).get(DEFAULT_QUALIFIER_ANNOTATION) != null;
        HashSet<Element> currentBindings = new HashSet<Element>();
        for (AnnotationMirror annotationMirror : qualifierAnnotations) {
            if (cancel.get()) {
                currentBindings.clear();
                break;
            }
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (annotationElement == null) continue;
            String annotationFQN = annotationElement.getQualifiedName().toString();
            this.findAnnotation(bindingCollections, annotationFQN, hasDefault, currentBindings, cancel);
        }
        if (hasDefault) {
            bindingCollections.add(currentBindings);
        }
        Set result = null;
        for (int i = 0; i < bindingCollections.size(); ++i) {
            Set list = (Set)bindingCollections.get(i);
            if (i == 0) {
                result = list;
                continue;
            }
            result.retainAll(list);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    private void findAnnotation(final List<Set<Element>> bindingCollections, final String annotationFQN, boolean hasCurrent, final Set<Element> currentBindings, final AtomicBoolean cancel) {
        try {
            final HashSet bindings = new HashSet();
            this.getModel().getHelper().getAnnotationScanner().findAnnotations(annotationFQN, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    if (AnnotationObjectProvider.hasAnnotation(element, FieldInjectionPointLogic.PRODUCER_ANNOTATION, FieldInjectionPointLogic.this.getModel().getHelper())) {
                        bindings.add(element);
                        bindings.addAll(FieldInjectionPointLogic.this.getChildSpecializes(element, FieldInjectionPointLogic.this.getModel(), cancel));
                        if (annotationFQN.contentEquals(FieldInjectionPointLogic.DEFAULT_QUALIFIER_ANNOTATION)) {
                            currentBindings.addAll(bindings);
                        } else {
                            bindingCollections.add(bindings);
                        }
                    }
                }
            });
            if (hasCurrent) {
                for (Element element : bindings) {
                    if (!AnnotationObjectProvider.checkDefault(element, this.getModel().getHelper())) continue;
                    currentBindings.add(element);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Finding annotation " + annotationFQN + " was interrupted");
        }
    }

    private Set<TypeElement> getBindingTypes(List<AnnotationMirror> qualifierAnnotations) {
        ArrayList bindingCollections = new ArrayList(qualifierAnnotations.size());
        boolean hasDefault = this.getModel().getHelper().getAnnotationsByType(qualifierAnnotations).get(DEFAULT_QUALIFIER_ANNOTATION) != null;
        HashSet<BindingQualifier> defaultQualifiers = new HashSet<BindingQualifier>();
        for (AnnotationMirror annotationMirror : qualifierAnnotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (annotationElement == null) continue;
            String annotationFQN = annotationElement.getQualifiedName().toString();
            PersistentObjectManager<BindingQualifier> manager = this.getModel().getManager(annotationFQN);
            Collection bindings = manager.getObjects();
            if (annotationFQN.contentEquals(DEFAULT_QUALIFIER_ANNOTATION)) {
                defaultQualifiers.addAll(bindings);
                continue;
            }
            bindingCollections.add(new HashSet(bindings));
            if (!hasDefault) continue;
            for (BindingQualifier binding : bindings) {
                if (!AnnotationObjectProvider.checkDefault(binding.getTypeElement(), this.getModel().getHelper())) continue;
                defaultQualifiers.add(new BindingQualifier(this.getModel().getHelper(), binding.getTypeElement(), DEFAULT_QUALIFIER_ANNOTATION));
            }
        }
        if (hasDefault) {
            bindingCollections.add(defaultQualifiers);
        }
        Set result = null;
        for (int i = 0; i < bindingCollections.size(); ++i) {
            Set set = (Set)bindingCollections.get(i);
            if (i == 0) {
                result = set;
                continue;
            }
            result.retainAll(set);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        for (BindingQualifier binding : result) {
            set.add(binding.getTypeElement());
        }
        return set;
    }

    protected static class DefinitionError
    extends Exception {
        private static final long serialVersionUID = 8538541504206293629L;
        private TypeElement myElement;

        protected DefinitionError(TypeElement element) {
            this.myElement = element;
        }

        public TypeElement getElement() {
            return this.myElement;
        }
    }

    protected static class InjectionPointDefinitionError
    extends Exception {
        private static final long serialVersionUID = -1568276063434281036L;

        private InjectionPointDefinitionError(String msg) {
            super(msg);
        }
    }
}

