/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.webservices;

import org.netbeans.modules.websvc.spi.webservices.WebServicesViewImpl;
import org.netbeans.modules.websvc.spi.webservices.WebServicesViewProvider;
import org.netbeans.modules.websvc.webservices.WebServicesViewAccessor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class WebServicesView {
    private WebServicesViewImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesViewProvider.class));

    private WebServicesView(WebServicesViewImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static WebServicesView getWebServicesView(FileObject f) {
        if (f != null) {
            for (WebServicesViewProvider impl : implementations.allInstances()) {
                WebServicesView wsv = impl.findWebServicesView(f);
                if (wsv == null) continue;
                return wsv;
            }
        }
        return null;
    }

    public Node createWebServicesView(FileObject srcRoot) {
        return this.impl.createWebServicesView(srcRoot);
    }

    static {
        WebServicesViewAccessor.DEFAULT = new WebServicesViewAccessor(){

            @Override
            public WebServicesView createWebServicesView(WebServicesViewImpl spiWebServicesView) {
                return new WebServicesView(spiWebServicesView);
            }

            @Override
            public WebServicesViewImpl getWebServicesViewImpl(WebServicesView wsv) {
                return wsv == null ? null : wsv.impl;
            }
        };
    }
}

