/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.net.URISyntaxException;
import org.netbeans.modules.mercurial.config.Scrambler;
import org.netbeans.modules.mercurial.ui.repository.HgURL;

public class RepositoryConnection {
    private static final String RC_DELIMITER = "~=~";
    private HgURL url;
    private String externalCommand;
    private boolean savePassword;

    public RepositoryConnection(String url) throws URISyntaxException {
        this(new HgURL(url), null, false);
    }

    public RepositoryConnection(String url, String username, String password, String externalCommand, boolean savePassword) throws URISyntaxException {
        this(new HgURL(url, username, password == null ? null : password.toCharArray()), externalCommand, savePassword);
    }

    public RepositoryConnection(HgURL url, String externalCommand, boolean savePassword) {
        this.url = url;
        this.externalCommand = externalCommand;
        this.savePassword = savePassword;
    }

    public HgURL getUrl() {
        return this.url;
    }

    String getUsername() {
        return this.url.getUsername();
    }

    char[] getPassword() {
        return this.url.getPassword();
    }

    public String getExternalCommand() {
        return this.externalCommand;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryConnection test = (RepositoryConnection)o;
        return this.url == test.url || this.url == null || this.url.equals(test.url);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.url.toString();
    }

    public static String getString(RepositoryConnection rc) {
        String url = rc.url.toUrlStringWithoutUserInfo();
        String username = rc.getUsername();
        String extCommand = rc.getExternalCommand();
        StringBuffer sb = new StringBuffer();
        sb.append(url);
        sb.append(RC_DELIMITER);
        if (username != null) {
            sb.append(username);
        }
        sb.append(RC_DELIMITER);
        sb.append("");
        sb.append(RC_DELIMITER);
        if (extCommand != null) {
            sb.append(extCommand);
        }
        sb.append(RC_DELIMITER);
        sb.append(RC_DELIMITER);
        return sb.toString();
    }

    public static RepositoryConnection parse(String str) throws URISyntaxException {
        String[] fields = str.split(RC_DELIMITER);
        int l = fields.length;
        String url = fields[0];
        String username = l > 1 && !fields[1].equals("") ? fields[1] : null;
        String password = l > 2 && !fields[2].equals("") ? Scrambler.getInstance().descramble(fields[2]) : null;
        String extCmd = l > 3 && !fields[3].equals("") ? fields[3] : null;
        boolean save = l > 4 && !fields[4].equals("") ? Boolean.parseBoolean(fields[4]) : true;
        return new RepositoryConnection(url, username, username != null ? password : null, extCmd, save);
    }
}

