/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.builder;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractXmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class DitaTopicDocumentBuilder
extends AbstractXmlDocumentBuilder {
    private static final String __TOPIC = "__topic";
    private static Set<Integer> entityReferenceToUnicode = new HashSet<Integer>();
    private final Stack<BlockDescription> blockDescriptions = new Stack();
    private String doctype = "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA 1.1 Topic//EN\" \"http://docs.oasis-open.org/dita/v1.1/OS/dtd/topic.dtd\">";
    private final Stack<TopicInfo> topicInfos = new Stack();
    private OutlineItem outline;
    private String filename;
    private int topicBreakLevel = Integer.MAX_VALUE;
    private String rootTitle;

    static {
        entityReferenceToUnicode.add(215);
        entityReferenceToUnicode.add(8211);
        entityReferenceToUnicode.add(8212);
        entityReferenceToUnicode.add(8220);
        entityReferenceToUnicode.add(8221);
        entityReferenceToUnicode.add(8216);
        entityReferenceToUnicode.add(8217);
    }

    public DitaTopicDocumentBuilder(Writer out) {
        super(out);
    }

    public DitaTopicDocumentBuilder(XmlStreamWriter writer) {
        this(writer, true);
    }

    public DitaTopicDocumentBuilder(XmlStreamWriter writer, boolean formatting) {
        super(formatting ? DitaTopicDocumentBuilder.wrapStreamWriter(writer) : writer);
    }

    @Override
    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
        XmlStreamWriter writer = super.createXmlStreamWriter(out);
        return DitaTopicDocumentBuilder.wrapStreamWriter(writer);
    }

    private static FormattingXMLStreamWriter wrapStreamWriter(XmlStreamWriter writer) {
        return new FormattingXMLStreamWriter(writer){

            @Override
            protected boolean preserveWhitespace(String elementName) {
                return elementName.equals("codeblock") || elementName.startsWith("pre");
            }
        };
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getDoctype() {
        return this.doctype;
    }

    @Override
    public void acronym(String text, String definition) {
        this.ensureOpenTopic();
        this.writer.writeStartElement("term");
        this.characters(text);
        this.writer.writeEndElement();
    }

    private BlockDescription findBlockDescription(DocumentBuilder.BlockType type) {
        int x = this.blockDescriptions.size() - 1;
        while (x >= 0) {
            BlockDescription blockDescription = (BlockDescription)this.blockDescriptions.get(x);
            if (blockDescription.type == type) {
                return blockDescription;
            }
            --x;
        }
        return null;
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        int blockSize;
        String elementName;
        this.ensureOpenTopic();
        String[] elementNames = null;
        boolean allowTitle = false;
        boolean closeElementsOnBlockStart = false;
        BlockDescription previousBlock = null;
        if (!this.blockDescriptions.isEmpty()) {
            previousBlock = this.blockDescriptions.peek();
        }
        boolean phraseTitle = false;
        switch (type) {
            case BULLETED_LIST: {
                elementName = "ul";
                break;
            }
            case NUMERIC_LIST: {
                elementName = "ol";
                break;
            }
            case DEFINITION_LIST: {
                elementName = "dl";
                break;
            }
            case DEFINITION_TERM: {
                BlockDescription blockDescription = this.findBlockDescription(DocumentBuilder.BlockType.DEFINITION_LIST);
                if (blockDescription.entrySize > 0) {
                    this.endBlockEntry(blockDescription);
                }
                this.openBlockEntry(blockDescription, new String[]{"dlentry"});
                elementName = "dt";
                break;
            }
            case DEFINITION_ITEM: {
                elementName = "dd";
                elementNames = new String[]{"p"};
                closeElementsOnBlockStart = true;
                break;
            }
            case PARAGRAPH: 
            case FOOTNOTE: {
                elementName = "p";
                break;
            }
            case CODE: {
                elementName = "pre";
                elementNames = new String[]{"codeph"};
                break;
            }
            case PREFORMATTED: {
                elementName = "pre";
                break;
            }
            case QUOTE: {
                elementName = "lq";
                break;
            }
            case LIST_ITEM: {
                elementName = "li";
                elementNames = new String[]{"p"};
                closeElementsOnBlockStart = true;
                break;
            }
            case TABLE: {
                elementName = "simpletable";
                break;
            }
            case TABLE_CELL_HEADER: {
                elementName = "stentry";
                break;
            }
            case TABLE_CELL_NORMAL: {
                elementName = "stentry";
                break;
            }
            case TABLE_ROW: {
                elementName = "strow";
                break;
            }
            case TIP: 
            case WARNING: 
            case INFORMATION: 
            case NOTE: 
            case PANEL: {
                elementName = "note";
                allowTitle = true;
                phraseTitle = true;
                break;
            }
            case DIV: {
                elementName = null;
                break;
            }
            default: {
                throw new IllegalStateException(type.name());
            }
        }
        if (elementName != null) {
            blockSize = 1;
            if (previousBlock != null && previousBlock.closeElementsOnBlockStart) {
                this.endBlockEntry(previousBlock);
            }
            this.writer.writeStartElement(elementName);
            switch (type) {
                case INFORMATION: {
                    this.writer.writeAttribute("type", "important");
                    break;
                }
                case NOTE: {
                    this.writer.writeAttribute("type", "note");
                    break;
                }
                case WARNING: {
                    this.writer.writeAttribute("type", "caution");
                    break;
                }
                case TIP: {
                    this.writer.writeAttribute("type", "tip");
                    break;
                }
                case PANEL: {
                    this.writer.writeAttribute("type", "other");
                }
            }
            this.applyAttributes(attributes);
            if (elementNames != null) {
                String[] stringArray = elementNames;
                int n = elementNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    this.writer.writeStartElement(name);
                    ++n2;
                }
            }
            if (allowTitle && attributes.getTitle() != null) {
                if (phraseTitle) {
                    this.writer.writeStartElement("ph");
                    this.writer.writeAttribute("outputclass", "title");
                    this.writer.writeCharacters(attributes.getTitle());
                    this.writer.writeEndElement();
                } else {
                    this.writer.writeStartElement("title");
                    this.writer.writeCharacters(attributes.getTitle());
                    this.writer.writeEndElement();
                }
            }
        } else {
            blockSize = 0;
        }
        this.blockDescriptions.push(new BlockDescription(type, blockSize, elementNames, closeElementsOnBlockStart));
    }

    @Override
    public void endBlock() {
        BlockDescription blockDescription = this.blockDescriptions.pop();
        int size = blockDescription.size + blockDescription.entrySize;
        int x = 0;
        while (x < size) {
            this.writer.writeEndElement();
            ++x;
        }
    }

    private void endBlockEntry(BlockDescription blockDescription) {
        int x = 0;
        while (x < blockDescription.entrySize) {
            this.writer.writeEndElement();
            ++x;
        }
        blockDescription.entrySize = 0;
    }

    private void openBlockEntry(BlockDescription blockDescription, String[] entry) {
        String[] stringArray = entry;
        int n = entry.length;
        int n2 = 0;
        while (n2 < n) {
            String ent = stringArray[n2];
            this.writer.writeStartElement(ent);
            ++n2;
        }
        blockDescription.entrySize += entry.length;
    }

    @Override
    public void beginDocument() {
        this.writer.writeStartDocument();
        this.writer.writeDTD(this.doctype);
        if (this.rootTitle != null) {
            this.writer.writeStartElement("topic");
            this.writer.writeStartElement("title");
            this.writer.writeCharacters(this.rootTitle);
            this.writer.writeEndElement();
        }
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        this.closeTopics(Math.max(level - 1, 0));
        if (this.topicInfos.isEmpty() || this.topicInfos.peek().headingLevel < level) {
            TopicInfo topicInfo = new TopicInfo();
            topicInfo.headingLevel = level;
            topicInfo.openElements = 2;
            this.topicInfos.push(topicInfo);
            this.writer.writeStartElement("topic");
            if (attributes != null) {
                this.applyAttributes(attributes);
                attributes = null;
            }
            this.writer.writeStartElement("title");
        }
    }

    private void applyAttributes(Attributes attributes) {
        if (attributes.getId() != null) {
            this.writer.writeAttribute("id", attributes.getId());
        }
        if (attributes.getCssClass() != null) {
            this.writer.writeAttribute("outputclass", attributes.getCssClass());
        }
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.ensureOpenTopic();
        switch (type) {
            case STRONG: 
            case BOLD: {
                this.writer.writeStartElement("b");
                break;
            }
            case CITATION: {
                this.writer.writeStartElement("cite");
                break;
            }
            case CODE: {
                this.writer.writeStartElement("codeph");
                break;
            }
            case DELETED: {
                this.writer.writeStartElement("ph");
                attributes.setCssClass(attributes.getCssClass() == null ? "deleted" : String.valueOf(attributes.getCssClass()) + " deleted");
                break;
            }
            case EMPHASIS: {
                this.writer.writeStartElement("i");
                break;
            }
            case INSERTED: {
                this.writer.writeStartElement("ph");
                attributes.setCssClass(attributes.getCssClass() == null ? "inserted" : String.valueOf(attributes.getCssClass()) + " inserted");
                break;
            }
            case UNDERLINED: {
                this.writer.writeStartElement("u");
                break;
            }
            case ITALIC: {
                this.writer.writeStartElement("i");
                break;
            }
            case SPAN: {
                this.writer.writeStartElement("ph");
                break;
            }
            case SUBSCRIPT: {
                this.writer.writeStartElement("sub");
                break;
            }
            case SUPERSCRIPT: {
                this.writer.writeStartElement("sup");
                break;
            }
            case MONOSPACE: {
                this.writer.writeStartElement("tt");
                break;
            }
            case QUOTE: {
                this.writer.writeStartElement("q");
                break;
            }
            case LINK: {
                LinkAttributes linkAttributes = (LinkAttributes)attributes;
                this.writer.writeStartElement("xref");
                this.writer.writeAttribute("href", this.computeDitaXref(linkAttributes.getHref()));
                break;
            }
            default: {
                Logger.getLogger(DocBookDocumentBuilder.class.getName()).warning("No DITA topic mapping for " + (Object)((Object)type));
                this.writer.writeStartElement("ph");
            }
        }
        this.applyAttributes(attributes);
    }

    @Override
    public void endSpan() {
        this.writer.writeEndElement();
    }

    @Override
    public void charactersUnescaped(String literal) {
        this.ensureOpenTopic();
        this.writer.writeLiteral(literal);
    }

    private void ensureOpenTopic() {
        if (this.topicInfos.isEmpty()) {
            this.beginHeading(1, new Attributes());
            this.endHeading();
        }
    }

    private void closeTopics(int toLevel) {
        TopicInfo topicInfo;
        if (toLevel < 0) {
            toLevel = 0;
        }
        while (!this.topicInfos.isEmpty() && this.topicInfos.peek().headingLevel > toLevel) {
            topicInfo = this.topicInfos.pop();
            int x = 0;
            while (x < topicInfo.openElements) {
                this.writer.writeEndElement();
                ++x;
            }
        }
        if (!this.topicInfos.isEmpty()) {
            topicInfo = this.topicInfos.peek();
            while (topicInfo.openElements > 1) {
                --topicInfo.openElements;
                this.writer.writeEndElement();
            }
        }
    }

    @Override
    public void endDocument() {
        this.closeTopics(0);
        if (this.rootTitle != null) {
            this.writer.writeEndElement();
        }
        this.writer.writeEndDocument();
    }

    @Override
    public void endHeading() {
        this.writer.writeEndElement();
        this.writer.writeStartElement("body");
    }

    @Override
    public void image(Attributes attributes, String url) {
        boolean emitAsFigure;
        this.ensureOpenTopic();
        boolean bl = emitAsFigure = attributes.getTitle() != null;
        if (emitAsFigure) {
            this.writer.writeStartElement("fig");
            this.writer.writeStartElement("title");
            this.writer.writeCharacters(attributes.getTitle());
            this.writer.writeEndElement();
        }
        this.writer.writeEmptyElement("image");
        this.writer.writeAttribute("href", url);
        this.applyImageAttributes(attributes);
        if (emitAsFigure) {
            this.writer.writeEndElement();
        }
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.ensureOpenTopic();
        this.writer.writeStartElement("xref");
        this.writer.writeAttribute("href", this.computeDitaXref(href));
        this.writer.writeAttribute("format", "html");
        this.image(imageAttributes, imageUrl);
        this.writer.writeEndElement();
    }

    private void applyImageAttributes(Attributes imageAttributes) {
        this.applyAttributes(imageAttributes);
        if (imageAttributes instanceof ImageAttributes) {
            ImageAttributes attributes = (ImageAttributes)imageAttributes;
            if (attributes.getAlt() != null) {
                this.writer.writeAttribute("alt", attributes.getAlt());
            }
            if (attributes.getHeight() > 0) {
                this.writer.writeAttribute("height", Integer.toString(attributes.getHeight()));
            }
            if (attributes.getWidth() > 0) {
                this.writer.writeAttribute("width", Integer.toString(attributes.getWidth()));
            }
            if (attributes.getAlign() != null) {
                switch (attributes.getAlign()) {
                    case Left: {
                        this.writer.writeAttribute("align", "center");
                        break;
                    }
                    case Right: {
                        this.writer.writeAttribute("align", "right");
                        break;
                    }
                    case Center: {
                        this.writer.writeAttribute("align", "center");
                    }
                }
                this.writer.writeAttribute("placement", "break");
            }
        }
    }

    @Override
    public void lineBreak() {
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.ensureOpenTopic();
        this.writer.writeStartElement("xref");
        this.writer.writeAttribute("href", this.computeDitaXref(hrefOrHashName));
        if (text != null) {
            this.characters(text);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void characters(String text) {
        this.ensureOpenTopic();
        super.characters(text);
    }

    @Override
    public void entityReference(String entity) {
        this.ensureOpenTopic();
        if (entity.startsWith("#")) {
            int unicodeValue;
            String numeric = entity.substring(1);
            int base = 10;
            if (numeric.startsWith("x")) {
                numeric = entity.substring(1);
                base = 16;
            }
            if (entityReferenceToUnicode.contains(unicodeValue = Integer.parseInt(numeric, base))) {
                this.writer.writeCharacters("" + (char)unicodeValue);
                return;
            }
        }
        this.writer.writeEntityRef(entity);
    }

    public OutlineItem getOutline() {
        return this.outline;
    }

    public void setOutline(OutlineItem outline) {
        this.outline = outline;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private String computeDitaXref(String href) {
        OutlineItem item;
        if (href.startsWith("#") && this.topicBreakLevel < Integer.MAX_VALUE && this.outline != null && (item = this.outline.findItemById(href.substring(1))) != null) {
            OutlineItem topicItem = this.computeTopicFileItem(item);
            String targetFilename = this.computeTargetFilename(topicItem);
            String ref = targetFilename.equals(this.filename) ? href : String.valueOf(targetFilename) + href;
            return ref;
        }
        return href;
    }

    public static String computeName(String headingId, String topicFilenameSuffix) {
        String name = headingId == null ? __TOPIC : headingId.replaceAll("[^a-zA-Z0-9_.-]", "-");
        name = String.valueOf(name) + topicFilenameSuffix;
        return name;
    }

    private String computeTargetFilename(OutlineItem item) {
        String filenameSuffix = this.filename.substring(this.filename.lastIndexOf(46));
        return DitaTopicDocumentBuilder.computeName(item.getLevel() == this.topicBreakLevel ? item.getId() : null, filenameSuffix);
    }

    private OutlineItem computeTopicFileItem(OutlineItem item) {
        while (item.getLevel() > this.topicBreakLevel && item.getParent() != null && item.getParent().getLevel() > this.topicBreakLevel - 1) {
            item = item.getParent();
        }
        return item;
    }

    public int getTopicBreakLevel() {
        return this.topicBreakLevel;
    }

    public void setTopicBreakLevel(int topicBreakLevel) {
        this.topicBreakLevel = topicBreakLevel;
    }

    public void setRootTopicTitle(String rootTitle) {
        this.rootTitle = rootTitle;
    }

    public String getRootTopicTitle() {
        return this.rootTitle;
    }

    private static class BlockDescription {
        DocumentBuilder.BlockType type;
        int size;
        int entrySize;
        final String[] nestedElementNames;
        final boolean closeElementsOnBlockStart;

        public BlockDescription(DocumentBuilder.BlockType type, int size, String[] nestedElementNames, boolean closeElementsOnBlockStart) {
            this.size = size;
            this.entrySize = nestedElementNames == null ? 0 : nestedElementNames.length;
            this.type = type;
            this.nestedElementNames = nestedElementNames;
            this.closeElementsOnBlockStart = closeElementsOnBlockStart;
        }
    }

    private static class TopicInfo {
        int headingLevel;
        int openElements;

        private TopicInfo() {
        }
    }
}

