/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public class MarkupParser {
    private MarkupLanguage markupLanguage;
    private DocumentBuilder builder;

    public MarkupParser() {
    }

    public MarkupParser(MarkupLanguage markupLanguage, DocumentBuilder builder) {
        this.markupLanguage = markupLanguage;
        this.builder = builder;
    }

    public MarkupParser(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public DocumentBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DocumentBuilder builder) {
        this.builder = builder;
    }

    public void parse(Reader markupContent) throws IOException {
        this.parse(markupContent, true);
    }

    public void parse(Reader markupContent, boolean asDocument) throws IOException {
        this.parse(this.readFully(markupContent), asDocument);
    }

    public void parse(String markupContent) {
        this.parse(markupContent, true);
    }

    public void parse(String markupContent, boolean asDocument) {
        if (this.markupLanguage == null) {
            throw new IllegalStateException("markup language is not set");
        }
        if (this.builder == null) {
            throw new IllegalStateException("builder is not set");
        }
        this.markupLanguage.processContent(this, markupContent, asDocument);
    }

    private String readFully(Reader reader) throws IOException {
        int c;
        StringWriter writer = new StringWriter();
        while ((c = reader.read()) != -1) {
            writer.write(c);
        }
        return writer.toString();
    }

    public String parseToHtml(String markupContent) {
        if (this.builder != null) {
            throw new IllegalStateException("Builder must not be set");
        }
        StringWriter out = new StringWriter();
        this.setBuilder(new HtmlDocumentBuilder(out));
        this.parse(markupContent);
        this.setBuilder(null);
        return out.toString();
    }
}

