/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnItem;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Identifier;
import org.netbeans.modules.db.sql.visualeditor.querymodel.UnaryExpression;

public class SetFunction
extends ColumnItem
implements UnaryExpression {
    public static final int NONE = 0;
    public static final int AVG = 1;
    public static final int COUNT = 2;
    public static final int MAX = 3;
    public static final int MIN = 4;
    public static final int SUM = 5;
    private int _type;
    private ColumnNode _argument;
    private Identifier _alias;

    private SetFunction() {
    }

    public SetFunction(int type, ColumnNode argument, Identifier alias) {
        this._type = type;
        this._argument = argument;
        this._alias = alias;
    }

    @Override
    Column getReferencedColumn() {
        return this._argument;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        columns.add(this._argument);
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String funcType = null;
        switch (this._type) {
            case 1: {
                funcType = "AVG(";
                break;
            }
            case 2: {
                funcType = "COUNT(";
                break;
            }
            case 3: {
                funcType = "MAX(";
                break;
            }
            case 4: {
                funcType = "MIN(";
                break;
            }
            case 5: {
                funcType = "SUM(";
                break;
            }
        }
        funcType = funcType + this._argument.genText(quoter);
        funcType = funcType + ")";
        if (this._alias != null) {
            funcType = funcType + " AS " + this._alias.genText(quoter);
        }
        return funcType;
    }

    @Override
    public Expression findExpression(String table1, String column1, String table2, String column2) {
        return null;
    }

    @Override
    public void renameTableSpec(String oldTableSpec, String corrName) {
        this._argument.renameTableSpec(oldTableSpec, corrName);
    }

    @Override
    public boolean isParameterized() {
        return false;
    }

    @Override
    public Expression getOperand() {
        return this._argument;
    }
}

