/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.common.spi.support.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.cloud.common.spi.support.ui.ServerResourceDescriptor;
import org.openide.util.NbBundle;

public class CloudResourcesWizardComponent
extends JPanel {
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public CloudResourcesWizardComponent(List<ServerResourceDescriptor> resources) {
        this.initComponents();
        this.setName(NbBundle.getBundle(CloudResourcesWizardComponent.class).getString("LBL_Name2"));
        this.setResources(resources);
    }

    private void setResources(List<ServerResourceDescriptor> resources) {
        ResourceModel m = new ResourceModel(resources);
        this.jTable.setModel(m);
        this.jTable.getColumnModel().getColumn(1).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof JLabel) {
                    return (JLabel)value;
                }
                return null;
            }
        });
        this.jTable.getColumnModel().getColumn(0).setWidth(30);
        this.jTable.getColumnModel().getColumn(1).setWidth(130);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JTable();
        this.jLabel1.setText(NbBundle.getMessage(CloudResourcesWizardComponent.class, (String)"CloudResourcesWizardComponent.jLabel1.text"));
        this.jTable.setAutoResizeMode(3);
        this.jScrollPane1.setViewportView(this.jTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 349, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 349, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 227, Short.MAX_VALUE)));
    }

    private static class ResourceModel
    implements TableModel {
        private List<ServerResourceDescriptor> resources;
        private String[] header = new String[]{"Type", "Name"};
        private Class[] headerClass = new Class[]{String.class, JLabel.class};

        public ResourceModel(List<ServerResourceDescriptor> resources) {
            this.resources = new ArrayList<ServerResourceDescriptor>(resources);
            if (this.resources.isEmpty()) {
                this.resources.add(new ServerResourceDescriptor("", "none available yet", "", null));
            }
        }

        @Override
        public int getRowCount() {
            return this.resources.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.header[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.headerClass[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ServerResourceDescriptor srd = this.resources.get(rowIndex);
            if (columnIndex == 0) {
                return srd.getType();
            }
            return new JLabel(srd.getName(), srd.getIcon(), 10);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

